package com.tiffintom.partner1.fragments;

import android.app.DatePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.TransactionsAndStatementsAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.RecyclerViewItemClickListener;
import com.tiffintom.partner1.models.Header;
import com.tiffintom.partner1.models.TransactionModel;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class PaymentTransactionFragment extends BaseFragment {

    private ArrayList<Object> transactions = new ArrayList<>();
    private RecyclerView rvTransactions;
    private TransactionsAndStatementsAdapter transactionsAndStatementsAdapter;
    private SwipeRefreshLayout swipeRefreshLayout;
    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private Calendar today = Calendar.getInstance();
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private ArrayList<TransactionModel> transactionModels = new ArrayList<>();
    private TextView tvToDate, tvFromDate, tvSelectTransactions;
    private RelativeLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private LinearLayout llMainLayout;
    private ImageView ivBack;
    private CardView cvCalendar;

    public static PaymentTransactionFragment getInstance() {
        return new PaymentTransactionFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragement_transaction, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            updateViews();
            setListeners();
            getData();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            cvCalendar = view.findViewById(R.id.cvCalender);
            llMainLayout = view.findViewById(R.id.llMainLayout);
            tvSelectTransactions = view.findViewById(R.id.tvSelectTransactions);
            tvSelectTransactions.setVisibility(View.GONE);

            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            ivBack = view.findViewById(R.id.ivBack);

            rvTransactions = view.findViewById(R.id.rvTransactions);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            transactionsAndStatementsAdapter = new TransactionsAndStatementsAdapter(getActivity(), transactions, new RecyclerViewItemClickListener() {
                @Override
                public void onItemClick(int position, Object data) {

                }
            });
            rvTransactions.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvTransactions.setNestedScrollingEnabled(false);
            rvTransactions.setAdapter(transactionsAndStatementsAdapter);
            rvTransactions.addItemDecoration(new StickHeaderItemDecoration(transactionsAndStatementsAdapter));

            cvCalendar.setVisibility(View.VISIBLE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DAY_OF_MONTH, -6);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
            swipeRefreshLayout.setOnRefreshListener(this::getData);
            llFromDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    fromDay = d;
                    fromMonth = m;
                    fromYear = y;
                    fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    fromCalendar.set(y, m, d);
                    tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    fetchTransactions();
                }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(toDate)) {
                    datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
                }
            });
            llToDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                    toDay = d;
                    toMonth = m;
                    toYear = y;
                    toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    toCalendar.set(y, m, d);
                    tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    fetchTransactions();
                }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.show();
                if (!Validators.isNullOrEmpty(fromDate)) {
                    datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void getData() {
        new Thread(this::fetchTransactions).start();
    }

    private void fetchTransactions() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("from_date", fromDate);
            params.put("to_date", toDate);
            params.put("restaurant_id", loggedInRestaurant.id);
            params.put("nopaginate", "1");
            AndroidNetworking.get(ApiEndPoints.payment_transactions)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(TransactionModel.class, new ParsedRequestListener<List<TransactionModel>>() {
                        @Override
                        public void onResponse(List<TransactionModel> response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }
                            try {
                                transactionModels.clear();
                                transactionModels.addAll(response);
                                setupAdapter();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> dayMonth = new ArrayList<>();

    private void setupAdapter() {
        try {
            dayMonth.clear();
            Calendar fromCalendarTemp = Calendar.getInstance();
            Calendar toCalendarTemp = Calendar.getInstance();

            fromCalendarTemp.setTime(fromCalendar.getTime());
            toCalendarTemp.setTime(toCalendar.getTime());

            fromCalendarTemp.add(Calendar.DAY_OF_MONTH, -1);
            while (toCalendarTemp.after(fromCalendarTemp)) {
                String dMonth = CommonFunctions.formatMiliToDesireFormat(toCalendarTemp.getTimeInMillis(), "dd MMMM");
                dayMonth.add(dMonth);
                LogUtils.e(dMonth);
                toCalendarTemp.add(Calendar.DAY_OF_MONTH, -1);
            }

            transactions.clear();

            for (String mmYY : dayMonth) {
                ArrayList<TransactionModel> monthlyTransactions = new ArrayList<>();
                for (TransactionModel transactionModel : transactionModels) {
                    String transactionDateMonth = CommonFunctions.formatUnknownDateTime(transactionModel.payment_date, MyApp.PHP_TIMEFORMAT, "dd MMMM");
                    if (transactionDateMonth.equals(mmYY)) {
                        monthlyTransactions.add(transactionModel);
                    }
                }
                if (monthlyTransactions.size() > 0) {
                    transactions.add(new Header(CommonFunctions.formatUnknownDateTime(mmYY, "dd MMMM", "EEE dd MMM")));
                    transactions.addAll(monthlyTransactions);
                }
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    transactionsAndStatementsAdapter.notifyDataSetChanged();
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
