package com.tiffintom.partner1.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import android.widget.ImageView
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.recyclerview.widget.RecyclerView
import com.tiffintom.partner1.R
import com.tiffintom.partner1.adapters.PaymentTypeSelectionAdapter
import com.tiffintom.partner1.base.BaseFragment
import com.tiffintom.partner1.models.AppIntroModel
import com.tiffintom.partner1.utils.Constants

class PaymentTypeSelection : BaseFragment() {
    var totalAmount = ""
    var edtAmount: EditText? = null
    var imgClose: ImageView? = null
    var rvSelection: RecyclerView? = null
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.fragment_payment_type_selection, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        edtAmount = view.findViewById(R.id.edt_amount)
        imgClose = view.findViewById(R.id.imgClose)
        rvSelection = view.findViewById(R.id.rvSelection)
        if(arguments!=null){
            totalAmount = requireArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT,"")
            edtAmount!!.setText("${myApp.currencySymbol}$totalAmount")
        }
        imgClose!!.setOnClickListener {
            requireActivity().onBackPressed()
        }
        setPaymentSelectionAdapter()
    }

    private fun setPaymentSelectionAdapter(){
        val paymentTypeSelection: ArrayList<AppIntroModel> = arrayListOf()
        if(loggedInMerchant!=null){
            val merchantRole = myApp.myPreferences.merchantRole
            val isAddCardReader = if (merchantRole == 2 && merchantBusiness.admin_permissions.payworks) {
                true
            } else if (merchantRole == 1 && merchantBusiness.supervisor_permissions.payworks) {
                true
            } else merchantRole == 0
            if(isAddCardReader){
                paymentTypeSelection.add(AppIntroModel(title = getString(R.string.card_reader)))
                if(myApp.myPreferences.deviceRegistration.is_tap_to_pay){
                    paymentTypeSelection.add(AppIntroModel(title = getString(R.string.tap_to_pay)))
                }
            }
            paymentTypeSelection.add(AppIntroModel(title = "Pay by link"))
            paymentTypeSelection.add(AppIntroModel(title = "Moto"))
            if(merchantBusiness.qr_permission){
                paymentTypeSelection.add(AppIntroModel(title = "QR"))
            }
        }
        val paymentTypeSelectionAdapter = PaymentTypeSelectionAdapter(this@PaymentTypeSelection.requireContext(),paymentTypeSelection){
            obj,position ->
            run {
                when(obj.title){
                    getString(R.string.card_reader)->{
                        changeFragment(CardReaderPaymentFragment.getInstance())
                    }
                    getString(R.string.tap_to_pay)->{
                        changeFragment(CardReaderPaymentFragment.getInstance(),true)
                    }
                    "Pay by link"->{
                        changeFragment(PaymentLinkFragment.getInstance())
                    }
                    "Moto"->{
                        changeFragment(MotoPaymentFragment.getInstance())
                    }
                    else->{
                        changeFragment(QRCodeFragment())
                    }
                }
            }
        }
        rvSelection!!.adapter = paymentTypeSelectionAdapter
    }

    private fun changeFragment(fragment: Fragment,isTap2Pay:Boolean= false) {
        val manager: FragmentManager = requireActivity().supportFragmentManager
        val transaction = manager.beginTransaction()
        arguments?.putBoolean(Constants.IS_TAP2_PAY,isTap2Pay)
        fragment.arguments = arguments
        transaction.replace(R.id.nav_host_fragment, fragment)
        transaction.addToBackStack("can_go_back")
        transaction.commit()
    }
}