package com.tiffintom.partner1.fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.radiobutton.MaterialRadioButton;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by Amrish on 27-11-2020.
 */
public class PreorderSetReminderFragment extends BaseBottomSheet {
    public static PreorderSetReminderFragment getInstance(OrderDetail orderDetail) {
        PreorderSetReminderFragment preorderSetReminderFragment = new PreorderSetReminderFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order", new Gson().toJson(orderDetail));
        preorderSetReminderFragment.setArguments(bundle);
        return preorderSetReminderFragment;
    }

    private RadioGroup rgTime;
    private MaterialRadioButton rb1Hour, rb2Hour, rb3Hour, rb4Hour, rb5Hour, rbCustomHour, rbCustom;
    private int hour = 0;
    private Date futureDate, deliveryDate;
    private Calendar todayCalendar = Calendar.getInstance();
    private Calendar reminderCalendar = Calendar.getInstance();
    private Calendar deliveryCalendar = Calendar.getInstance();
    private OrderDetail orderDetail;
    private MaterialButton btnConfirm, btnCancel;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_preorder_setreminder, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setCalendars();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            orderDetail = new Gson().fromJson(getArguments().getString("order"), OrderDetail.class);
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            rgTime = view.findViewById(R.id.rgTime);
            ivClose = view.findViewById(R.id.ivClose);
            rb1Hour = view.findViewById(R.id.rbOneHour);
            rb2Hour = view.findViewById(R.id.rbTwoHour);
            rb3Hour = view.findViewById(R.id.rbThreeHour);
            rb4Hour = view.findViewById(R.id.rbFourHour);
            rb5Hour = view.findViewById(R.id.rbFiveHour);
            rbCustomHour = view.findViewById(R.id.rbCustomHour);
            rbCustom = view.findViewById(R.id.rbCustom);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setListeners() {
        super.setListeners();
        try {
            rgTime.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(RadioGroup radioGroup, int i) {
                    if (i == R.id.rbOneHour) {
                        hour = 1;
                    } else if (i == R.id.rbTwoHour) {
                        hour = 2;
                    } else if (i == R.id.rbThreeHour) {
                        hour = 3;
                    } else if (i == R.id.rbFourHour) {
                        hour = 4;
                    } else if (i == R.id.rbFiveHour) {
                        hour = 5;
                    } else if (i == R.id.rbCustom) {
                        showEditHours();
                    } else if (i == R.id.rbCustomHour) {
                        hour = customHour;
                    }
                }
            });
            btnCancel.setOnClickListener(view -> dismiss());
            btnConfirm.setOnClickListener(view -> {
                if (hour > 0) {
                    reminderCalendar.set(Calendar.HOUR_OF_DAY, deliveryCalendar.get(Calendar.HOUR_OF_DAY));
                    reminderCalendar.add(Calendar.HOUR_OF_DAY, -hour);
                    LogUtils.e("Order Date: ", CommonFunctions.formatMiliToDesireFormat(deliveryDate.getTime(), "dd-MM-yyyy hh:mm a"));
                    LogUtils.e("Reminder Date: ", CommonFunctions.formatMiliToDesireFormat(reminderCalendar.getTimeInMillis(), "dd-MM-yyyy hh:mm a"));
                    LogUtils.e("Current Date: ", CommonFunctions.formatMiliToDesireFormat(todayCalendar.getTimeInMillis(), "dd-MM-yyyy hh:mm a"));
                    ToastUtils.makeToast(getActivity(), "Reminder set for order");
                    dismiss();
                } else {
                    ToastUtils.makeToast(getActivity(), "Please select reminder");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCalendars() {
        try {
            deliveryDate = CommonFunctions.convertStringDateToDate((CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, MyApp.DEL_TIMEFORMAT, "dd-MM-yyyy") + " " + CommonFunctions.convertTimeFormat(orderDetail.delivery_time)), "dd-MM-yyyy hh:mm a");
            deliveryCalendar.setTime(deliveryDate);
            reminderCalendar.setTime(deliveryDate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int customHour = 0;

    private void showEditHours() {
        try {
            rbCustom.setChecked(false);
            AlertDialog alertDialog = new AlertDialog.Builder(getActivity()).create();
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            View dialogView = inflater.inflate(R.layout.dialog_set_custom_time, null);

            MaterialButton btnConfirm = dialogView.findViewById(R.id.btnConfirm);
            MaterialButton btnCancel = dialogView.findViewById(R.id.btnCancel);
            AppCompatEditText etHour = dialogView.findViewById(R.id.etHours);
            if (customHour > 0) {
                etHour.setText(String.valueOf(customHour));
                etHour.setSelection(etHour.getText().toString().length());
            }
            btnConfirm.setOnClickListener(view -> {
                if (!etHour.getText().toString().isEmpty() && Integer.parseInt(etHour.getText().toString()) > 0) {
                    customHour = Integer.parseInt((etHour.getText().toString()));
                    hour = customHour;
                    rbCustomHour.setText(customHour + " hours before delivery");
                    rbCustomHour.setChecked(true);
                    rbCustomHour.setVisibility(View.VISIBLE);
                    alertDialog.dismiss();
                } else {
                    ToastUtils.makeToast(getActivity(), "Please enter valid hour");
                }
            });
            btnCancel.setOnClickListener(view -> {

                if (hour == 1) {
                    rb1Hour.setChecked(true);
                } else if (hour == 2) {
                    rb2Hour.setChecked(true);
                } else if (hour == 3) {
                    rb3Hour.setChecked(true);
                } else if (hour == 4) {
                    rb4Hour.setChecked(true);
                } else if (hour == 5) {
                    rb5Hour.setChecked(true);
                } else {
                    rbCustomHour.setChecked(customHour > 0);
                }
                alertDialog.dismiss();
            });
            alertDialog.setView(dialogView);
            alertDialog.setCancelable(false);
            alertDialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
