package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.PrintTransactionsReportAdapter;
import com.tiffintom.partner1.adapters.ReportSummaryFiltersAdapter;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.ApiError;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.models.TransactionSummary;
import com.tiffintom.partner1.models.TransactionSummaryDynamic;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * Created by Amrish on 11-11-2020.
 */
public class PrintReportOptionsDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    protected MyApp myApp = MyApp.getInstance();
    protected AlertDialog progressDialog;
    protected Merchant loggedInMerchant = myApp.getMyPreferences().getLoggedInMerchant();
    private String title, info;
    private boolean reject;
    private MaterialButton btnConfirm, btnCancel,btnCancelPrint,btnConfirmPrint;
    private TextView tvInfo, tvTitle,tvDate;
    private RadioGroup rgDateRange;
    private DialogDismissListener dialogDismissListener;
    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private Calendar todayCalendar = Calendar.getInstance();
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private ArrayList<TransactionSummaryDynamic> dynamics = new ArrayList<>();
    private ReportSummaryFiltersAdapter filtersAdapter;
    private PrintTransactionsReportAdapter printTransactionsReportAdapter;
    TransactionSummary reportSummary;
    private RecyclerView rvFilters,rvReportList;
    private ConstraintLayout constViewReport;
    private CardView cvPrintFilterSelection;

    public static PrintReportOptionsDialogFragment getInstance() {
        PrintReportOptionsDialogFragment rejectReasonDialog = new PrintReportOptionsDialogFragment();
        Bundle bundle = new Bundle();
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_print_report_options_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            info = getArguments().getString("info");
            reject = getArguments().getBoolean("reject");
            initViews(view);
            setListeners();
            fetchReports();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity(), "Loading...");

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            constViewReport = view.findViewById(R.id.constViewReport);
            cvPrintFilterSelection = view.findViewById(R.id.cvPrintFilterSelection);
            rgDateRange = view.findViewById(R.id.rgDateRange);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnConfirmPrint = view.findViewById(R.id.btnConfirmPrint);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnCancelPrint = view.findViewById(R.id.btnCancelPrint);
            tvInfo = view.findViewById(R.id.tvInfo);
            tvTitle = view.findViewById(R.id.tvTitle);
            tvDate = view.findViewById(R.id.tvDate);

            rvFilters = view.findViewById(R.id.rvFilters);
            rvReportList = view.findViewById(R.id.rvReportList);
            rvFilters.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.HORIZONTAL, false));

            filtersAdapter = new ReportSummaryFiltersAdapter(dynamics, (position, data) -> {
                clickReport(data);
            });
            rvFilters.setAdapter(filtersAdapter);

            printTransactionsReportAdapter = new PrintTransactionsReportAdapter(new ArrayList<>());
            rvReportList.setAdapter(printTransactionsReportAdapter);

            btnConfirm.setEnabled(false);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clickReport(Object data) {
        try {
            TransactionSummaryDynamic dynamic = (TransactionSummaryDynamic) data;
            reportSummary = dynamic.report;
            reportSummary.date_range = "Date: " + CommonFunctions.formatUnknownDateTime(dynamic.from_date, MyApp.PHP_TIMEFORMAT, "dd MMM yyyy");
            if (dynamic.filter.equalsIgnoreCase("last_3_days")) {
                reportSummary.date_range = dynamic.from_date;
                reportSummary.date_range = "Date: " + CommonFunctions.formatUnknownDateTime(dynamic.from_date, MyApp.PHP_TIMEFORMAT, "dd MMM yyyy") + " to " + CommonFunctions.formatUnknownDateTime(dynamic.to_date, MyApp.PHP_TIMEFORMAT, "dd MMM yyyy");
            }
            btnConfirm.setEnabled(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            rgDateRange.setOnCheckedChangeListener((radioGroup, i) -> {
                if (i == R.id.rbToday) {
                    fromCalendar = Calendar.getInstance();
                    toCalendar = Calendar.getInstance();

                    fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
                    toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
                } else if (i == R.id.rbYesterday) {
                    fromCalendar = Calendar.getInstance();
                    toCalendar = Calendar.getInstance();
                    fromCalendar.add(Calendar.DAY_OF_MONTH, -1);
                    toCalendar.add(Calendar.DAY_OF_MONTH, -1);
                    fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
                    toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
                } else if (i == R.id.rb3days) {
                    fromCalendar = Calendar.getInstance();
                    toCalendar = Calendar.getInstance();
                    fromCalendar.add(Calendar.DAY_OF_MONTH, -3);
                    fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
                    toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
                }
            });
            btnConfirm.setOnClickListener(view -> {
               /* if (dialogDismissListener != null && reportSummary != null) {
                    dialogDismissListener.onDialogDismiss(reportSummary);
                }
                dismiss();*/
                if(reportSummary != null) {
                    tvDate.setText(reportSummary.date_range);
                    cvPrintFilterSelection.setVisibility(View.GONE);
                    constViewReport.setVisibility(View.VISIBLE);
                    ArrayList<TransactionSummaryDynamic> summaryDynamics = new ArrayList<>();
                    TransactionSummaryDynamic transactionSummaryDynamic = new TransactionSummaryDynamic();
                    transactionSummaryDynamic.title = "Transaction";
                    transactionSummaryDynamic.value = reportSummary.totalTransaction;
                    summaryDynamics.add(transactionSummaryDynamic);

                    TransactionSummaryDynamic transactionSummaryDynamic1 = new TransactionSummaryDynamic();
                    transactionSummaryDynamic1.title = "Refund Amount";
                    transactionSummaryDynamic1.value = myApp.currencySymbol+MyApp.df.format(reportSummary.totalRefundAmount);
                    summaryDynamics.add(transactionSummaryDynamic1);

                    TransactionSummaryDynamic transactionSummaryDynamic2 = new TransactionSummaryDynamic();
                    transactionSummaryDynamic2.title = "Refund Transactions";
                    transactionSummaryDynamic2.value =reportSummary.totalRefundTransactions;
                    summaryDynamics.add(transactionSummaryDynamic2);

                    TransactionSummaryDynamic transactionSummaryDynamic3 = new TransactionSummaryDynamic();
                    transactionSummaryDynamic3.title = "Successful Amount";
                    transactionSummaryDynamic3.value = myApp.currencySymbol+MyApp.df.format(reportSummary.totalSuccessfulAmount);
                    summaryDynamics.add(transactionSummaryDynamic3);

                    TransactionSummaryDynamic transactionSummaryDynamic4 = new TransactionSummaryDynamic();
                    transactionSummaryDynamic4.title = "Successful Transactions";
                    transactionSummaryDynamic4.value =reportSummary.totalSuccessfulTransactions;
                    summaryDynamics.add(transactionSummaryDynamic4);
                    printTransactionsReportAdapter.notifyList(summaryDynamics);
                }
            });
            btnConfirmPrint.setOnClickListener(view -> {
                if (dialogDismissListener != null && reportSummary != null) {
                    dialogDismissListener.onDialogDismiss(reportSummary);
                }
                dismiss();
            });
            btnCancel.setOnClickListener(view -> {
                dismiss();
            });
            btnCancelPrint.setOnClickListener(view -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchReports() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressDialog.show();
                });
            }
            AndroidNetworking.post(ApiEndPoints.MERCHANT_REPORT_SUMMARY)
                    .addPathParameter("business_id", myApp.getMyPreferences().getBusinessId())
                    .addBodyParameter("from_date", fromDate)
                    .addBodyParameter("to_date", toDate)
                    .addBodyParameter("dynamic", "1")
                    .build()
                    .getAsObjectList(TransactionSummaryDynamic.class, new ParsedRequestListener<List<TransactionSummaryDynamic>>() {
                        @Override
                        public void onResponse(List<TransactionSummaryDynamic> response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                        dynamics.clear();
                                        dynamics.addAll(response);
                                        filtersAdapter.notifyDataSetChanged();
                                        if (dynamics.size() > 0) {
                                            filtersAdapter.selectedFilter = dynamics.get(0).filter;
                                            clickReport(dynamics.get(0));
                                            filtersAdapter.notifyDataSetChanged();
                                        }
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeLongToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


}
