package com.tiffintom.partner1.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.widget.NestedScrollView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.airbnb.lottie.LottieAnimationView
import com.androidnetworking.AndroidNetworking
import com.androidnetworking.error.ANError
import com.androidnetworking.interfaces.JSONObjectRequestListener
import com.androidnetworking.interfaces.ParsedRequestListener
import com.google.android.material.button.MaterialButton
import com.tiffintom.partner1.BuildConfig
import com.tiffintom.partner1.R
import com.tiffintom.partner1.adapters.TransactionsAndStatementsAdapter
import com.tiffintom.partner1.base.BaseFragment
import com.tiffintom.partner1.common.CommonFunctions
import com.tiffintom.partner1.common.Validators
import com.tiffintom.partner1.interfaces.MoneyTextWatcher
import com.tiffintom.partner1.models.PaymentLink
import com.tiffintom.partner1.network.ApiEndPoints
import com.tiffintom.partner1.qrcode_generator.QRGContents
import com.tiffintom.partner1.qrcode_generator.QRGEncoder
import com.tiffintom.partner1.utils.Constants
import org.json.JSONObject
import java.util.Calendar

class QRCodeFragment : BaseFragment() {
    private var qrgEncoder: QRGEncoder? = null
    private var svQRCode: NestedScrollView? = null
    private var constQrCode: ConstraintLayout? = null
    private var llGenerateQRCode: LinearLayout? = null
    private var llMainLayout: ConstraintLayout? = null
    private var lotti_qr: LottieAnimationView? = null
    private var txt_loading_qr: TextView? = null
    private var txtAmountDisplay: TextView? = null
    private var imgQrCode: ImageView? = null
    private var btnSend: MaterialButton? = null
    private var btnCancel: MaterialButton? = null
    private var etAmount: EditText? = null
    var stripe_private_key: String? = null
    var stripe_public_key: String? = null
    var stripe_mode: String? = null
    var descriptor: String? = null
    var description: String? = null
    private var rvPaymentLinks: RecyclerView? = null
    private var transactionsAndStatementsAdapter: TransactionsAndStatementsAdapter? = null
    private val paymentLinks = ArrayList<Any>()
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_q_r_code, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView(view)
        getRecentPaymentLinks()
    }

    private fun initView(view: View) {
        // if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && !Validators.isNullOrEmpty(merchantBusiness.connect_stripe_public_key)) {
        if (!Validators.isNullOrEmpty(merchantBusiness.s_account_id) && !Validators.isNullOrEmpty(
                BuildConfig.connect_stripe_public_key
            )
        ) {
            stripe_private_key = BuildConfig.connect_stripe_private_key
            stripe_public_key = BuildConfig.connect_stripe_public_key
        } else {
            if (stripe_mode.equals("live", ignoreCase = true)) {
                stripe_private_key = BuildConfig.stripe_private_key_live
                stripe_public_key = BuildConfig.stripe_public_key_live
            } else {
                stripe_private_key = BuildConfig.stripe_private_key_test
                stripe_public_key = BuildConfig.stripe_public_key_test
            }
        }
        rvPaymentLinks = view.findViewById(R.id.rvPaymentLinks)
        svQRCode = view.findViewById(R.id.svQRCode)
        constQrCode = view.findViewById(R.id.constQrCode)
        llMainLayout = view.findViewById(R.id.llMainLayout)
        lotti_qr = view.findViewById(R.id.lotti_qr)
        txt_loading_qr = view.findViewById(R.id.txt_loading_qr)
        txtAmountDisplay = view.findViewById(R.id.txtAmountDisplay)
        imgQrCode = view.findViewById(R.id.img_qr_code)
        llGenerateQRCode = view.findViewById(R.id.llGenerateQRCode)
        btnCancel = view.findViewById(R.id.btnCancel)
        etAmount = view.findViewById(R.id.etAmount)
        etAmount!!.addTextChangedListener(MoneyTextWatcher(etAmount))
        btnSend = view.findViewById(R.id.btnSend)
        btnCancel!!.setOnClickListener {
            CommonFunctions.hideKeyboard(activity, etAmount)
            requireActivity().onBackPressed()
        }
        btnSend!!.setOnClickListener {
            if (Validators.isNullOrEmpty(etAmount!!.text.toString())) {
                etAmount!!.error = "Please enter amount"
                etAmount!!.requestFocus()
            } else if (etAmount!!.text.toString().replace(",", "").toFloat() == 0F) {
                etAmount!!.error = "Amount should be greater than zero"
                etAmount!!.requestFocus()
            } else {
                Thread { this.generatePaymentLink() }.start()
            }
        }
        rvPaymentLinks!!.layoutManager = LinearLayoutManager(activity, RecyclerView.VERTICAL, false)

        transactionsAndStatementsAdapter = TransactionsAndStatementsAdapter(true,
            activity, paymentLinks
        ) { _: Int, data: Any? ->
            txtAmountDisplay!!.text ="${myApp.currencySymbol}${(data as PaymentLink).amount}"
            generateQr(data.link)
            svQRCode!!.smoothScrollTo(0,0)
        }
        rvPaymentLinks!!.adapter = transactionsAndStatementsAdapter
        if (arguments != null && requireArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT) != null) {
            etAmount!!.setText(requireArguments().getString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT))
            btnSend!!.performClick()
        }
    }

    private fun generateParam(): HashMap<String, String> {
        val totalAmount = etAmount!!.text.toString().replace(",", "").toDouble()
        val id = ""
        val stringStringHashMap = HashMap<String, String>()
        stringStringHashMap["phone"] = ""
        stringStringHashMap["secretkey"] = stripe_private_key!!
        stringStringHashMap["publishkey"] = stripe_public_key!!
        stringStringHashMap["amount"] = totalAmount.toString()
        stringStringHashMap["name"] = merchantBusiness!!.name
        stringStringHashMap["business_id"] = merchantBusiness!!.id
        stringStringHashMap["order_id"] = id
        stringStringHashMap["qr"] = "1"
        //.addBodyParameter("device_id", myPreferences.getUserFCMToken())
        stringStringHashMap["device_id"] = myApp.myPreferences.userFCMToken
        stringStringHashMap["description"] =
            merchantBusiness!!.statement_description
        stringStringHashMap["descriptor"] =
            merchantBusiness!!.statement_descriptor
        return stringStringHashMap
    }

    private fun generatePaymentLink() {
        try {
            val totalAmount = etAmount!!.text.toString().replace(",", "").toFloat()
            if (totalAmount <= 0.30) {
                CommonFunctions.showSnackBar(
                    activity,
                    llMainLayout,
                    "Amount should be greater than 0.30"
                )
                return
            }
            if (activity != null) {
                requireActivity().runOnUiThread {
                    imgQrCode!!.visibility = View.GONE
                    constQrCode!!.visibility = View.GONE
                    progressDialog.show()
                }
            }

            AndroidNetworking.post(ApiEndPoints.payment_message)
                .addQueryParameter(generateParam())
                .build()
                .getAsJSONObject(object : JSONObjectRequestListener {
                    override fun onResponse(response: JSONObject) {
                        if (activity != null) {
                            activity!!.runOnUiThread {
                                progressDialog.dismiss()
                                txtAmountDisplay!!.text ="${myApp.currencySymbol}${etAmount!!.text}"
                                etAmount!!.text = null
                                CommonFunctions.hideKeyboard(activity, etAmount)

                                try {
                                    CommonFunctions.showSnackBar(
                                        activity,
                                        llMainLayout,
                                        "QR CODE generated successfully."
                                    )
                                    generateQr( response.getString("payment_link"))
                                    getRecentPaymentLinks()
                                } catch (e: Exception) {
                                    e.printStackTrace()
                                }
                            }
                        }
                    }

                    override fun onError(anError: ANError) {
                        if (activity != null) {
                            activity!!.runOnUiThread { progressDialog.dismiss() }
                        }
                        anError.printStackTrace()
                    }
                })
        } catch (e: NumberFormatException) {
            e.printStackTrace()
        }
    }

    private fun generateQr(payment_link:String){
        qrgEncoder = QRGEncoder(
            payment_link,
            null,
            QRGContents.Type.TEXT,
            300
        )
        imgQrCode!!.visibility = View.VISIBLE
        constQrCode!!.visibility = View.VISIBLE
        lotti_qr!!.visibility = View.GONE
        txt_loading_qr!!.visibility = View.GONE
        imgQrCode!!.setImageBitmap(qrgEncoder!!.getBitmap(0))
    }

    private fun getRecentPaymentLinks() {
        try {
            val toCalendar = Calendar.getInstance()
            val params = HashMap<String, String>()
            params["business_id"] = merchantBusiness.id
            params["nopaginate"] = "1"
            params["qr"] = "1"
            params["to_date"] =
                CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd")
                    .replace("/", "-")
            params["from_date"] =
                CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd")
                    .replace("/", "-")
            AndroidNetworking.get(ApiEndPoints.payment_message)
                .addQueryParameter(params) //.addBodyParameter("action", "paymentLinks")
                // .addBodyParameter("name", merchantBusiness.name)
                .build()
                .getAsObjectList(
                    PaymentLink::class.java,
                    object : ParsedRequestListener<List<PaymentLink>> {
                        override fun onResponse(response: List<PaymentLink>) {
                            if (activity != null) {
                                activity!!.runOnUiThread {}
                            }
                            try {
                                paymentLinks.clear()
                                paymentLinks.addAll(response)
                                transactionsAndStatementsAdapter!!.notifyDataSetChanged()
                            } catch (e: java.lang.Exception) {
                                e.printStackTrace()
                            }
                        }

                        override fun onError(anError: ANError) {
                            try {
                                if (activity != null) {
                                    activity!!.runOnUiThread { progressDialog.dismiss() }
                                }
                                anError.printStackTrace()
                            } catch (e: java.lang.Exception) {
                                e.printStackTrace()
                            }
                        }
                    })
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }
}