package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.ReasonSelectionAdapter;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Created by Amrish on 11-11-2020.
 */
public class RejectReasonDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private ArrayList<String> reasons = new ArrayList<>();
    private RecyclerView rvReasons;
    private ReasonSelectionAdapter reasonSelectionAdapter;
    private MaterialButton btnConfirm, btnCancel;
    private DialogDismissListener dialogDismissListener;
    private String selectedReason;
    private AppCompatEditText etOtherReason;

    public static RejectReasonDialogFragment getInstance(String reasons) {
        RejectReasonDialogFragment rejectReasonDialogFragment = new RejectReasonDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("reasons", reasons);
        rejectReasonDialogFragment.setArguments(bundle);
        return rejectReasonDialogFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_reject_reason, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        reasons.addAll(Arrays.asList(getArguments().getString("reasons").split(",")));
        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        try {
            rvReasons = view.findViewById(R.id.rvReasons);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            etOtherReason = view.findViewById(R.id.etOtherReason);
            reasonSelectionAdapter = new ReasonSelectionAdapter(reasons, (position, data) -> {
                reasonSelectionAdapter.notifyDataSetChanged();
                selectedReason = (String) data;
                etOtherReason.setText(selectedReason);
                if (selectedReason.trim().equalsIgnoreCase("other")) {
                    etOtherReason.setText("");
                    etOtherReason.setVisibility(View.VISIBLE);
                } else {
                    etOtherReason.setVisibility(View.GONE);
                }
            });
            rvReasons.setAdapter(reasonSelectionAdapter);
            rvReasons.setLayoutManager(new GridLayoutManager(getActivity(), 2));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (!Validators.isNullOrEmpty(etOtherReason.getText().toString())) {
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss(etOtherReason.getText().toString());
                        dismiss();
                    }
                } else {
                    ToastUtils.makeToast(getActivity(), "Please provide reason");
                }
            });
            btnCancel.setOnClickListener(view -> dismiss());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
