package com.tiffintom.partner1.fragments;

import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.Calendar;

/**
 * Created by Amrish on 11-11-2020.
 */
public class ReservationViewBottomSheetFragment extends BaseBottomSheet {

    private Reservation reservation;
    private DialogDismissListener dialogDismissListener;
    private TextView tvPersonalDetails, tvNoOfGuests;
    private LinearLayout llInstructions, llCancelReason;
    private TextView tvInstructions, tvInstructionTitle, tvCancelReasonTitle, tvCancelReason;
    private MaterialButton btnAccept, btnReject;
    Calendar todayCalendar = Calendar.getInstance();
    private SunmiPrinter sunmiPrinter;
    private ImageView ivPrint;
    private TextView tvReservationNumber;
    private BluetoothPrinter bluetoothPrinter;

    public static ReservationViewBottomSheetFragment getInstance(Reservation reservation) {
        ReservationViewBottomSheetFragment orderViewBottomSheetFragment = new ReservationViewBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("reservation", new Gson().toJson(reservation));
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_reservationview_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            todayCalendar.add(Calendar.DAY_OF_MONTH, -1);
            updateViews();
            setListners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListners() {
        super.setListeners();
        try {
            btnAccept.setOnClickListener(v -> {
                if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss("accept");
                dismiss();
            });
            btnReject.setOnClickListener(v -> {
                if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss("reject");
                dismiss();
            });
            ivPrint.setOnClickListener(view -> {
                if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                    if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                        myApp.iMinPrinterUtils.printReservation(reservation, myApp.restaurantLogo);
                    } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                        if (ReservationsFragment.zoneRichPrinter == null) {
                            ToastUtils.makeToast(getActivity(), "Printer is not connected");
                        } else {
                            ReservationsFragment.zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                            ReservationsFragment.zoneRichPrinter.printReservation(reservation, myApp.restaurantLogo);
                        }
                    } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(200);
                                    bluetoothPrinter.printReservation(reservation, myApp.restaurantLogo);
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        sunmiPrinter.printReservation(getActivity(), reservation);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (intentExtrasData.containsKey("reservation")) {
                reservation = new Gson().fromJson(String.valueOf(intentExtrasData.get("reservation")), Reservation.class);
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            sunmiPrinter = new SunmiPrinter(getActivity());
            bluetoothPrinter = new BluetoothPrinter(getActivity());

            ivClose = view.findViewById(R.id.ivClose);
            ivPrint = view.findViewById(R.id.ivPrint);

            tvReservationNumber = view.findViewById(R.id.tvBookingNumber);
            tvPersonalDetails = view.findViewById(R.id.tvPersonalDetails);
            tvInstructions = view.findViewById(R.id.tvInstructions);
            tvInstructionTitle = view.findViewById(R.id.tvInstructionsTitle);
            llInstructions = view.findViewById(R.id.cvInstruction);
            btnAccept = view.findViewById(R.id.btnAccept);
            btnReject = view.findViewById(R.id.btnReject);
            tvNoOfGuests = view.findViewById(R.id.tvNoOfGuests);
            llCancelReason = view.findViewById(R.id.llCancelReason);
            tvCancelReasonTitle = view.findViewById(R.id.tvCancelReasionTitle);
            tvCancelReason = view.findViewById(R.id.tvCancelReason);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            if (reservation != null) {
                StringBuilder personalDetailsBuilder = new StringBuilder();
                personalDetailsBuilder.append("Name: ");
                personalDetailsBuilder.append(reservation.customer_name);
                personalDetailsBuilder.append("\n");
                personalDetailsBuilder.append("Contact number: ");
                personalDetailsBuilder.append(reservation.booking_phone);
                personalDetailsBuilder.append("\n");
                personalDetailsBuilder.append("Reservation on: ");
                personalDetailsBuilder.append(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd MMM yyyy"));
                personalDetailsBuilder.append(" at ");
                personalDetailsBuilder.append(reservation.booking_time);
                tvPersonalDetails.setText(personalDetailsBuilder);
                tvReservationNumber.setText(reservation.booking_id);
                tvInstructions.setText(reservation.booking_instruction);
                tvNoOfGuests.setText(reservation.guest_count + " guests");

                if (!Validators.isNullOrEmpty(reservation.booking_instruction)) {
                    tvInstructionTitle.setVisibility(View.VISIBLE);
                    llInstructions.setVisibility(View.VISIBLE);
                } else {
                    tvInstructionTitle.setVisibility(View.GONE);
                    llInstructions.setVisibility(View.GONE);
                }

                if (!Validators.isNullOrEmpty(reservation.cancel_reason)) {
                    tvCancelReasonTitle.setVisibility(View.VISIBLE);
                    llCancelReason.setVisibility(View.VISIBLE);
                } else {
                    tvCancelReasonTitle.setVisibility(View.GONE);
                    llCancelReason.setVisibility(View.GONE);
                }

                String orderStatus = "View";

                if (reservation.status.equalsIgnoreCase("pending")) {
                    orderStatus = "Accept";
                } else if (reservation.status.equalsIgnoreCase("cancelled") || reservation.status.equalsIgnoreCase("cancel")) {
                    orderStatus = "Cancelled";
                } else if (reservation.status.equalsIgnoreCase("approved")) {
                    orderStatus = "Completed";
                }
                if (orderStatus.equalsIgnoreCase("accept")) {
                    btnReject.setText("Cancel");
                } else if (orderStatus.equalsIgnoreCase("cancelled")) {
                    btnAccept.setVisibility(View.GONE);
                    btnReject.setVisibility(View.GONE);
                    tvCancelReasonTitle.setVisibility(View.VISIBLE);
                    llCancelReason.setVisibility(View.VISIBLE);
                    tvCancelReason.setText(reservation.cancel_reason);
                } else if (orderStatus.equalsIgnoreCase("completed")) {
                    btnAccept.setVisibility(View.GONE);
                    btnReject.setVisibility(View.GONE);

                } else if (orderStatus.equalsIgnoreCase("cancel")) {
                    btnReject.setText("Cancel");
                    btnAccept.setVisibility(View.GONE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
