package com.tiffintom.partner1.fragments;

import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.reflect.TypeToken;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.ReservationsAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.common.bluetoothprinter.BluetoothPrinter;
import com.tiffintom.partner1.common.printer.SunmiPrinter;
import com.tiffintom.partner1.common.printer.ZoneRichPrinter;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.interfaces.FilterDialogDismissListener;
import com.tiffintom.partner1.models.OrderStatusIndicatorHeader;
import com.tiffintom.partner1.models.Reservation;
import com.tiffintom.partner1.models.RestaurantOrder;
import com.tiffintom.partner1.models.RestaurantOrderResponse;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.ToastUtils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Amrish on 09-11-2020.
 */
public class ReservationsAllFragment extends BaseFragment {
    private RestaurantOrderResponse ordersResponse;
    private ArrayList<Object> reservations = new ArrayList<>();
    private RecyclerView rvReservations;
    private ReservationsAdapter reservationsAdapter;
    private SwitchCompat switchCompat;
    private LinearLayout llLoading, llData, llNoRecord;
    private boolean custom = false;
    private String sort_by = "Today";
    private String toDate, fromDate;
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private LinearLayout llFilter;
    private TextView tvFilter;
    private SunmiPrinter sunmiPrinter;
    private ZoneRichPrinter zoneRichPrinter;
    private BluetoothPrinter bluetoothPrinter;
    private boolean justPrint = false;
    private Reservation reservation;
    private ImageView ivBack;
    private Snackbar greySnackBar;
    private CoordinatorLayout coordinatorLayout;

    private Type reservationTypeToken = new TypeToken<List<Reservation>>() {
    }.getType();
    private ArrayList<Reservation> reservationArrayList = new ArrayList<>();

    public static ReservationsAllFragment getInstance() {
        return new ReservationsAllFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_reservations_all, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            updateOrderTakingStatus();
            setListeners();
            fetchData();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }


    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            coordinatorLayout = view.findViewById(R.id.coordinatorLayout);
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            llFilter = view.findViewById(R.id.llFiler);
            tvFilter = view.findViewById(R.id.tvFilter);
            rvReservations = view.findViewById(R.id.rvReservations);
            switchCompat = view.findViewById(R.id.switchOrders);
            llLoading = view.findViewById(R.id.llLoading);
            llData = view.findViewById(R.id.llData);
            llNoRecord = view.findViewById(R.id.llNoRecord);
            ivBack = view.findViewById(R.id.ivBack);

            reservationsAdapter = new ReservationsAdapter(getActivity(), reservations, (view1, position, data) -> {
                //View clicked
                reservation = (Reservation) data;
                ReservationViewBottomSheetFragment reservationViewBottomSheetFragment = ReservationViewBottomSheetFragment.getInstance((Reservation) data);
                reservationViewBottomSheetFragment.show(getChildFragmentManager(), "reservation_view");
                reservationViewBottomSheetFragment.setDialogDismissListener(reservationViewDismissListener);
            }, (view1, position, data) -> {
                //Accept clicked
                reservation = (Reservation) data;
                openConfirmReservationDialog();

            }, (view12, position, data) -> {
                //Cancel clicked
                reservation = (Reservation) data;
                openRejectReservationDialog();

            }, (view1, position, data) -> {
                //Print clicked
                reservation = (Reservation) data;
                if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                    if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                        myApp.iMinPrinterUtils.printReservation(reservation, myApp.restaurantLogo);
                    } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                        if (zoneRichPrinter == null) {
                            ToastUtils.makeToast(getActivity(), "Printer is not connected");
                        } else {
                            zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                            zoneRichPrinter.printReservation(reservation, myApp.restaurantLogo);
                        }
                    } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(200);
                                    bluetoothPrinter.printReservation(reservation, myApp.restaurantLogo);
                                } else {
                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        sunmiPrinter.printReservation(getActivity(), reservation);
                    }
                }
            });
            rvReservations.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvReservations.setNestedScrollingEnabled(false);
            rvReservations.addItemDecoration(new StickHeaderItemDecoration(reservationsAdapter));
            rvReservations.setAdapter(reservationsAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
            switchCompat.setOnCheckedChangeListener(checkedChangeListener);
            llFilter.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    FilterSelectionFragment filterSelectionFragment = FilterSelectionFragment.getInstance(fromDate, toDate);
                    filterSelectionFragment.show(getChildFragmentManager(), "filters");
                    filterSelectionFragment.setFilterDialogDismissListener(new FilterDialogDismissListener() {
                        @Override
                        public void onDialogDismiss(Date from, Date to) {

                        }

                        @Override
                        public void onDialogDismiss(String from, String to) {

                        }

                        @Override
                        public void onDialogDismiss(String filter, String from, String to) {
                            if (filter.equalsIgnoreCase("custom")) {
                                custom = true;
                                fromDate = from;
                                toDate = to;
                                tvFilter.setText(fromDate + " - " + toDate);
                            } else {
                                custom = false;
                                sort_by = filter.replace(" ", "");
                                tvFilter.setText(filter);
                            }
                            fetchData();
                        }
                    });
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openConfirmReservationDialog() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Accept Booking", "Do you want to confirm this booking?", false);
            confirmationDialogFragment.show(getChildFragmentManager(), "reservation_accept");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                String action = (String) o; //confirm, cancel
                if (action.equalsIgnoreCase("confirm")) {
                    changeStatus("Approved");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    DialogDismissListener reservationViewDismissListener = o -> {
        try {
            String action = (String) o;
            if (action.equalsIgnoreCase("accept")) {
                openConfirmReservationDialog();
            } else if (action.equalsIgnoreCase("reject")) {
                openRejectReservationDialog();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    };
    String cancelReason;

    private void openRejectReservationDialog() {
        try {
            RejectReasonDialogFragment rejectReasonDialogFragment = RejectReasonDialogFragment.getInstance("Customer cancelled,Fully booked,Customer error,Other");
            rejectReasonDialogFragment.show(getChildFragmentManager(), "reject_reservation");
            rejectReasonDialogFragment.setDialogDismissListener(o -> {
                cancelReason = (String) o;
                changeStatus("Cancel");
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        new Thread(this::fetchOrders).start();
    }

    private void fetchOrders() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            //'ThisWeek','ThisMonth','ThisYear','Today', 'Yesterday'
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id);
            params.put("previous_status", "1");
            params.put("nopaginate", "1");
            if (!custom) {
                if (sort_by.equalsIgnoreCase("Today")) {
                    params.put("from_date", toDate.replace("/", "-"));
                    params.put("to_date", toDate.replace("/", "-"));
                } else if (sort_by.equalsIgnoreCase("ThisWeek")) {
                    params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
                    params.put("from_date", CommonFunctions.getPreviousDate(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"), -6));
                } else if (sort_by.equalsIgnoreCase("ThisMonth")) {
                    params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
                    params.put("from_date", CommonFunctions.getPreviousDate(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"), -30));
                } else if (sort_by.equalsIgnoreCase("ThisYear")) {
                    params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
                    params.put("from_date", CommonFunctions.getPreviousDate(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"), -365));
                } else {
                    params.put("from_date", fromDate.replace("/", "-"));
                    params.put("to_date", toDate.replace("/", "-"));
                }
            } else {
                params.put("from_date", fromDate.replace("/", "-"));
                params.put("to_date", toDate.replace("/", "-"));
            }
            AndroidNetworking.get(ApiEndPoints.bookings)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(Reservation.class, new ParsedRequestListener<List<Reservation>>() {
                        @Override
                        public void onResponse(List<Reservation> response) {
                            try {
                                reservations.clear();
                                reservationArrayList.clear();
                                reservationArrayList.addAll(response);
                                reservations.add(new OrderStatusIndicatorHeader("Completed bookings (" + reservationArrayList.size() + ")"));
                                reservations.addAll(reservationArrayList);

                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llData.setVisibility(View.VISIBLE);
                                        reservationsAdapter.notifyDataSetChanged();
                                    });
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llNoRecord.setVisibility(View.VISIBLE);
                                    });
                                }
                                anError.printStackTrace();
                                if (!CommonFunctions.isConnected(getActivity())) {
                                    myApp.noInternet(getActivity());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
            EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("online_order", b ? "Yes" : "No");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "enter_password");
            enterPasswordDialogFragment.setCancelable(false);
            enterPasswordDialogFragment.setDialogDismissListener(changeOrderAcceptingStatusDialogListener);
        }
    };
    DialogDismissListener changeOrderAcceptingStatusDialogListener = new DialogDismissListener() {
        @Override
        public void onDialogDismiss(Object o) {
            switchCompat.setOnCheckedChangeListener(null);
            updateOrderTakingStatus();
            switchCompat.setOnCheckedChangeListener(checkedChangeListener);
        }
    };

    private void changeStatus(String status) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressDialog.show();
                });
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id);

            if (status.equalsIgnoreCase("Cancel")) {
                params.put("cancel_reason", cancelReason);
            }
            params.put("status", status);
            ANRequest.PostRequestBuilder anRequest;
            anRequest = AndroidNetworking.post(ApiEndPoints.bookings+"/"+reservation.id+"/change-status")
                    .addQueryParameter(params);
            anRequest
                    .build()
                    .getAsObject(Reservation.class, new ParsedRequestListener<Reservation>() {
                        @Override
                        public void onResponse(Reservation response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                    });
                                }
                                Reservation printReservation = response;
                                cancelReason = "";
                                if (!myApp.getMyPreferences().getDefaultPrinter().equalsIgnoreCase("mobile")) {
                                    if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("imin")) {
                                        myApp.iMinPrinterUtils.printReservation(reservation, myApp.restaurantLogo);
                                    } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains("ip printer")) {
                                        if (zoneRichPrinter == null) {
                                            ToastUtils.makeToast(getActivity(), "Printer is not connected");
                                        } else {
                                            zoneRichPrinter.connectPrinter(myApp.getMyPreferences().getPrinterIP());
                                            zoneRichPrinter.printReservation(printReservation, myApp.restaurantLogo);
                                        }
                                    } else if (myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP_80) || myApp.getMyPreferences().getDefaultPrinter().toLowerCase().contains(Constants.KP80)) {
                                        try {
                                            if (bluetoothPrinter != null) {
                                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                if (device != null) {
                                                    CommonFunctions.functionThatDelay(200);
                                                    bluetoothPrinter.printReservation(reservation, myApp.restaurantLogo);
                                                } else {
                                                    ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                                }
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        sunmiPrinter.printReservation(getActivity(), printReservation);
                                    }
                                }
                                fetchData();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                    });
                                }
                                if (!CommonFunctions.isConnected(getActivity())) {
                                    myApp.noInternet(getActivity());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void updateOrderTakingStatus() {
        switchCompat.setChecked(myApp.getMyPreferences().getLoggedInRestaurant().online_order.equalsIgnoreCase("Yes"));
        fromCalendar.add(Calendar.DAY_OF_MONTH, -1);
        fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
        toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
    }

    private ArrayList<RestaurantOrder> sortOrdersByNew(ArrayList<RestaurantOrder> orders) {
        Collections.sort(orders, (restaurantOrder, t1) -> {
            Date orderDateLHS;
            if (!Validators.isNullOrEmpty(restaurantOrder.order_type)) {
                String date = restaurantOrder.delivery_date.split("T")[0] + " " + restaurantOrder.delivery_time;
                orderDateLHS = CommonFunctions.convertStringDateToDate(date, "dd-MM-yyyy hh:mm a");
            } else {
                orderDateLHS = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(restaurantOrder.created.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy hh:mm a"), "dd-MM-yyyy hh:mm a");
            }

            Date orderDateRHS;
            if (!Validators.isNullOrEmpty(t1.order_type)) {
                String date = t1.delivery_date.split("T")[0] + " " + t1.delivery_time;
                orderDateRHS = CommonFunctions.convertStringDateToDate(date, "dd-MM-yyyy hh:mm a");
            } else {
                orderDateRHS = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(t1.created.replace(":", ""), "yyyy-MM-dd'T'hhmmssZ", "dd-MM-yyyy hh:mm a"), "dd-MM-yyyy hh:mm a");
            }

            return orderDateLHS.compareTo(orderDateRHS);
        });
        return orders;
    }

    @Override
    public void onStop() {
        if (getActivity() != null && progressDialog != null) {
            progressDialog.dismiss();
        }
        super.onStop();
    }

}
