package com.tiffintom.partner1.fragments;

import static android.Manifest.permission.RECORD_AUDIO;
import static android.Manifest.permission.WRITE_EXTERNAL_STORAGE;
import static com.tiffintom.partner1.utils.Constants.CODE_IMAGE_PICKER;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.Chronometer;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.devlomi.record_view.OnBasketAnimationEnd;
import com.devlomi.record_view.OnRecordListener;
import com.devlomi.record_view.RecordButton;
import com.devlomi.record_view.RecordView;
import com.github.dhaval2404.imagepicker.ImagePicker;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.ChatAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.StickHeaderItemDecoration;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.Dategroup;
import com.tiffintom.partner1.models.Message;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.utils.LogUtils;
import com.tiffintom.partner1.utils.ToastUtils;

import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/**
 * Created by Amrish on 12-09-2020.
 */
public class RestaurantChatWindowFragment extends BaseFragment {

    public static RestaurantChatWindowFragment getInstance(String order_id, String customer_id, String customer_name, String customer_logo) {
        RestaurantChatWindowFragment restaurantChatWindowFragment = new RestaurantChatWindowFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_id", order_id);
        bundle.putString("customer_id", customer_id);
        bundle.putString("customer_name", customer_name);
        bundle.putString("customer_logo", customer_logo);
        restaurantChatWindowFragment.setArguments(bundle);
        return restaurantChatWindowFragment;
    }

    public static RestaurantChatWindowFragment getInstance() {
        return new RestaurantChatWindowFragment();
    }

    private LinearLayoutManager linearLayoutManager;
    private RecyclerView rvMessages;
    private EditText etMessage;
    private ImageView ivCamera, ivSend;
    private ArrayList<Object> feed = new ArrayList<>();
    private ArrayList<Message> allMessages = new ArrayList<>();
    private ArrayList<Message> oldMessages = new ArrayList<>();
    private ChatAdapter chatAdapter;
    private String customer_id, customer_name, customer_phone, intentCustomerImage, intentOrderId;
    public static String multiMediaPath;
    private ImageView ivRecord;
    private TextView tvRecordingTime;
    private ImageView ivRecordingStatus;
    private LinearLayout llRecordingView, llInputMain;
    private Chronometer chronometer;
    private RecordButton recordButton;
    private RecordView recordView;
    private TextView tvTitle;
    private ImageView ivBack, ivCall;
    boolean isRequestOnGoing;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_restaurant_chat_window, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                customer_id = getArguments().getString("customer_id");
                customer_name = getArguments().getString("customer_name");
                customer_phone = getArguments().getString("customer_phone");
                intentOrderId = getArguments().getString("order_id");
                intentCustomerImage = getArguments().getString("customer_logo");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            rvMessages = view.findViewById(R.id.rvMessages);
            etMessage = view.findViewById(R.id.etMessage);
            ivCamera = view.findViewById(R.id.ivCamera);
            ivSend = view.findViewById(R.id.ivSend);
            ivRecord = view.findViewById(R.id.ivRecord);
            ivBack = view.findViewById(R.id.ivBack);
            ivCall = view.findViewById(R.id.ivCall);
            tvTitle = view.findViewById(R.id.tvTitle);
            recordButton = view.findViewById(R.id.record_button);
            recordView = view.findViewById(R.id.record_view);
            ((ImageView) recordView.findViewById(R.id.basket_img)).setColorFilter(Color.WHITE);
            llInputMain = view.findViewById(R.id.llInputMain);
            llRecordingView = view.findViewById(R.id.llRecordingView);
            tvRecordingTime = view.findViewById(R.id.tvRecordingTime);
            ivRecordingStatus = view.findViewById(R.id.ivRecordingStatus);
            chronometer = view.findViewById(R.id.chronometer);
            chatAdapter = new ChatAdapter(feed, (position, data) -> {

            }, intentCustomerImage);
            linearLayoutManager = new LinearLayoutManager(getContext(), RecyclerView.VERTICAL, false);
            rvMessages.setLayoutManager(linearLayoutManager);
            rvMessages.setAdapter(chatAdapter);
            rvMessages.addItemDecoration(new StickHeaderItemDecoration(chatAdapter));
            ivSend.setAlpha(0.4f);
            ivSend.setEnabled(false);
            if (!Validators.isNullOrEmpty(customer_phone)) {
                ivCall.setVisibility(View.VISIBLE);
            } else {
                ivCall.setVisibility(View.GONE);
            }
            tvTitle.setText(customer_name);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            blinkRecording();
            ivSend.setOnClickListener(view -> {
                if (!Validators.isNullOrEmpty(etMessage.getText().toString()) && etMessage.getText().toString().trim().length() > 0) {
                    sendMessage(etMessage.getText().toString().trim(), null, "0");
                    etMessage.setText("");
                    CommonFunctions.hideKeyboard(getActivity(), etMessage);
                }
            });
            ivCamera.setOnClickListener(view -> {
                pickImage();
            });
            ivBack.setOnClickListener((view) -> {
                getActivity().onBackPressed();
            });
            ivCall.setOnClickListener((view) -> {
                Intent intent = new Intent();
                intent.setAction(Intent.ACTION_DIAL);
                intent.setData(Uri.parse("tel: " + customer_phone));
                startActivity(intent);
            });
            recordButton.setRecordView(recordView);
            recordView.setOnRecordListener(new OnRecordListener() {
                @Override
                public void onStart() {
                    startRecording();
                    //Start Recording..
                    llInputMain.setVisibility(View.INVISIBLE);
                    LogUtils.e("RecordView:::", "onStart");
                }

                @Override
                public void onCancel() {
                    //On Swipe To Cancel
                    cancelRecording();
                    LogUtils.e("RecordView:::", "onCancel");

                }

                @Override
                public void onFinish(long recordTime) {
                    //Stop Recording..
                    stopRecording();
                    llInputMain.setVisibility(View.VISIBLE);
                    LogUtils.e("RecordView:::", "onFinish");

                    LogUtils.e("RecordTime:::", String.valueOf(recordTime));
                }

                @Override
                public void onLessThanSecond() {
                    //When the record time is less than One Second
                    llInputMain.setVisibility(View.VISIBLE);
                    cancelRecording();
                    LogUtils.e("RecordView:::", "onLessThanSecond");
                }
            });
            recordView.setOnBasketAnimationEndListener(new OnBasketAnimationEnd() {
                @Override
                public void onAnimationEnd() {
                    LogUtils.e("RecordView", "Basket Animation Finished");
                    llInputMain.setVisibility(View.VISIBLE);
                }
            });
            ivRecord.setOnClickListener(view -> {
            });
            ivRecord.setOnTouchListener((view, event) -> {
                switch (event.getAction()) {
                    case MotionEvent.ACTION_DOWN:
                        startRecording();
                        startRecordingTimer();
                        //This is where my code for movement is initialized to get original location.
                        break;
                    case MotionEvent.ACTION_UP:
                        stopRecordingTimer();
                        if (mediaRecorder != null) {
                            stopRecording();
                        }
                        return false;
                    case MotionEvent.ACTION_MOVE:
                        //Code for movement here. This may include using a window manager to update the view
                        break;
                }
                return true;
            });

            etMessage.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    if (etMessage.getText().toString().trim().length() == 0) {
                        ivSend.setAlpha(0.4f);
                        ivSend.setEnabled(false);
                    } else {
                        ivSend.setAlpha(1f);
                        ivSend.setEnabled(true);
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            rvMessages.addOnLayoutChangeListener((view, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
                if (bottom < oldBottom) {
                    rvMessages.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            rvMessages.scrollToPosition(
                                    rvMessages.getAdapter().getItemCount() - 1);
                        }
                    }, 100);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cancelRecording() {
        try {
            if (mediaRecorder != null) {
                try {
                    mediaRecorder.stop();
                    mediaRecorder.release();
                    mediaRecorder = null;
                    if (audioFile.exists()) {
                        audioFile.delete();
                    }
                    LogUtils.e("Recoding Cancelled");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startRecordingTimer() {
        try {
            llInputMain.setVisibility(View.GONE);
            llRecordingView.setVisibility(View.VISIBLE);
            tvRecordingTime.setText("Recording ");
            chronometer.setBase(SystemClock.elapsedRealtime());
            chronometer.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopRecordingTimer() {
        try {
            llInputMain.setVisibility(View.VISIBLE);
            llRecordingView.setVisibility(View.GONE);
            chronometer.stop();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void blinkRecording() {
        try {
            Animation animation = new AlphaAnimation(1, 0); //to change visibility from visible to invisible
            animation.setDuration(500); //1 second duration for each animation cycle
            animation.setInterpolator(new LinearInterpolator());
            animation.setRepeatCount(Animation.INFINITE); //repeating indefinitely
            animation.setRepeatMode(Animation.REVERSE); //animation will start from end point once ended.
            ivRecordingStatus.startAnimation(animation); //to start animation
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startRecording() {
        try {
            random = new Random();
            if (checkPermission()) {

                String root = Environment.getExternalStorageDirectory().getAbsolutePath();
                File directory = new File(root + "/TiffinTom/Chat/Audio/");
                String audioFileName = CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd HH:mm:ss") + " Recording.mp3";
                if (!directory.exists()) directory.mkdirs();
                audioFile = new File(directory, audioFileName);

                mediaRecorder = new MediaRecorder();
                mediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
                mediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
                mediaRecorder.setAudioEncoder(MediaRecorder.OutputFormat.AMR_NB);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    mediaRecorder.setOutputFile(audioFile);
                } else {
                    mediaRecorder.setOutputFile(audioFile.getAbsolutePath());
                }

                try {
                    mediaRecorder.prepare();
                    mediaRecorder.start();
                } catch (IllegalStateException | IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }

            } else {
                requestPermission();
            }
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }


    private void stopRecording() {
        try {
            mediaRecorder.stop();
            mediaRecorder.release();
            sendMessage(null, audioFile, "2");
            mediaRecorder = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getAllMessages(String lastMsgId, boolean autoRefresh) {
        try {
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("customer_id", customer_id);
            hashMap.put("restaurant_id", loggedInRestaurant.id);
            hashMap.put("user_id", customer_id);
            hashMap.put("nopaginate", "1");
            if (lastMsgId != null) {
                hashMap.put("last_id", lastMsgId);
            }
            isRequestOnGoing = true;
            AndroidNetworking.get(ApiEndPoints.orders_help)
                    .addQueryParameter(hashMap)
                    .build()
                    .getAsObjectList(Message.class, new ParsedRequestListener<List<Message>>() {
                        @Override
                        public void onResponse(List<Message> response) {
                            isRequestOnGoing = false;
                            boolean newMessage = false;
                            LogUtils.e("Auto Refresh? " + autoRefresh);
                            try {
                                feed.clear();
                                if (!autoRefresh) {
                                    allMessages.clear();
                                    LogUtils.e("Cleared");
                                }
                                oldMessages.clear();
                                oldMessages.addAll(response);
                                allMessages.addAll(oldMessages);
                                newMessage = true;

                                setupAdapter();
                                if (!autoRefresh) {
                                    LogUtils.e("Feed " + feed.size());
                                    rvMessages.scrollToPosition(feed.size() - 1);
                                } else {
                                    if (newMessage && linearLayoutManager.findLastCompletelyVisibleItemPosition() + 1 != feed.size()) {
                                        rvMessages.scrollToPosition(feed.size() - 1);
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (!autoRefresh) setAutoFetch();
                        }

                        @Override
                        public void onError(ANError anError) {
                            isRequestOnGoing = false;
                            anError.printStackTrace();
                            if (!autoRefresh && !CommonFunctions.isConnected(getActivity()))
                                myApp.noInternet(getActivity());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupAdapter() {
        try {
            feed.clear();
            ArrayList<String> dates = new ArrayList<>();

            for (Message message : allMessages) {

                String messageDate = CommonFunctions.formatUnknownDateTime(message.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "EEE dd MMM, yyyy");
                int datesIndex = -1;
                if (!dates.contains(messageDate)) {
                    dates.add(messageDate);
                    LogUtils.e(messageDate);
                }
            }
            for (String date : dates) {
                feed.add(new Dategroup(date));
                for (Message message : allMessages) {

                    String messageDate = CommonFunctions.formatUnknownDateTime(message.created, MyApp.PHP_DATE_TIME_FORMAT_ZULU, "EEE dd MMM, yyyy");
                    if (messageDate.equals(date))
                        feed.add(message);

                }
            }
            chatAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //0 msg,1 img 2 audio
    private void sendMessage(String message, File file, String type) {

        try {
            if (type.equals("2")) {
                if (getActivity() != null)
                    getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();

            //params.put("action", "OrderhelpMessage");
            if (type.equalsIgnoreCase("0"))
                params.put("message", message);
            else params.put("message", "");
            params.put("customer_id", customer_id);
            params.put("user_id", customer_id);
            params.put("order_id", intentOrderId);
            params.put("restaurant_id", loggedInRestaurant.id);
            params.put("is_attach", type);
            params.put("admin", "1");
            params.put("status", "1");

            ANRequest.MultiPartBuilder androidNetworking = AndroidNetworking.upload(ApiEndPoints.orders_help)
                    .addMultipartParameter(params);
            if (!type.equalsIgnoreCase("0")) {
                androidNetworking.addMultipartFile("attach", file);
            }

            androidNetworking
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                Message m = new Gson().fromJson(response.toString(), Message.class);
                                allMessages.add(m);
                                setupAdapter();
                                rvMessages.scrollToPosition(feed.size() - 1);
                                if (file != null && file.exists()) {
                                    file.delete();
                                }
                                if (getActivity() != null && progressDialog != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pickImage() {
        ImagePicker.Companion.with(this)
                .crop()                    //Crop image(Optional), Check Customization for more option
                .compress(1024)            //Final image size will be less than 1 MB(Optional)
                .maxResultSize(1080, 1080)    //Final image resolution will be less than 1080 x 1080(Optional)
                .start(CODE_IMAGE_PICKER);
    }

    File audioFile;
    MediaRecorder mediaRecorder;
    Random random;
    public static final int RequestPermissionCode = 1;

    private void requestPermission() {
        ActivityCompat.requestPermissions(getActivity(), new
                String[]{WRITE_EXTERNAL_STORAGE, RECORD_AUDIO}, RequestPermissionCode);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        if (requestCode == RequestPermissionCode) {
            if (grantResults.length > 0) {
                boolean StoragePermission = grantResults[0] ==
                        PackageManager.PERMISSION_GRANTED;
                boolean RecordPermission = grantResults[1] ==
                        PackageManager.PERMISSION_GRANTED;

                if (!StoragePermission || !RecordPermission) {
                    ToastUtils.makeToast(getActivity(), "Permissions denied");
                }
            }
        }
    }

    public boolean checkPermission() {
        int result = ContextCompat.checkSelfPermission(getActivity(),
                WRITE_EXTERNAL_STORAGE);
        int result1 = ContextCompat.checkSelfPermission(getActivity(),
                RECORD_AUDIO);
        return result == PackageManager.PERMISSION_GRANTED &&
                result1 == PackageManager.PERMISSION_GRANTED;
    }

    Handler handler = new Handler();
    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            String lastMsgId = null;
            for (Object o : feed) {
                if (o instanceof Message) {
                    if (((Message) o).id != 0) {
                        lastMsgId = String.valueOf(((Message) o).id);
                    }
                }
            }
            getAllMessages(lastMsgId, true);
            handler.postDelayed(runnable, 5 * 1000);
        }
    };

    private void setAutoFetch() {
        handler.postDelayed(runnable, 5 * 1000);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == CODE_IMAGE_PICKER) {
            if (data != null) {
                File userImageFile = ImagePicker.Companion.getFile(data);
                if (userImageFile != null && userImageFile.exists())
                    sendMessage(null, userImageFile, "1");
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        getAllMessages(null, false);
    }

    @Override
    public void onStop() {
        handler.removeCallbacks(runnable);
        if (mediaRecorder != null) mediaRecorder.stop();
        super.onStop();
    }
}
