package com.tiffintom.partner1.fragments;

import android.graphics.Paint;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;
import androidx.viewpager.widget.ViewPager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.iarcuschin.simpleratingbar.SimpleRatingBar;
import com.lwj.widget.viewpagerindicator.ViewPagerIndicator;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.RecentReviewViewPagerAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.LatestReviewModel;
import com.tiffintom.partner1.models.ReviewModel;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.util.ArrayList;
import java.util.HashMap;

public class ReviewFragment extends BaseFragment {

    private TextView tvAvgReview, tvAvgTotalReviews, tvAvgNewReview, tvViewAll, tvRespond, tvRecentView, tvComplaintCount, tvClickToView, tvPeriviousComplaint, tvPeriviousStatus, tvComplaintView, tvAvgMessageCount, tvRecentMessageCount;
    private SimpleRatingBar rbAvgRatings;
    private RelativeLayout rlAvgUnreadCount, rlRecentUnreadCount, rlComplaintUnreadCount;
    private ViewPager vpRecentReview;
    private RecentReviewViewPagerAdapter vpAdapter;
    private ViewPagerIndicator viewPagerIndicator;
    private ReviewModel reviewModel;
    private ArrayList<Object> reviewArrayList = new ArrayList<>();
    private LinearLayout llNewReview, llRespond, llNoRecords, llLoading, llMainLayout;

    public static ReviewFragment getInstance() {
        return new ReviewFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_reviews_ratings, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        fetchData();
        setListener();
    }

    private void setListener() {

        try {
            tvRespond.setOnClickListener(v -> openResponceBottomsheet());

            vpRecentReview.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                    if (reviewArrayList.size() > 0) {
                        LatestReviewModel latestReviewModel = (LatestReviewModel) reviewArrayList.get(position);
                        if (Validators.isNullOrEmpty(latestReviewModel.responce)) {
                            tvRespond.setVisibility(View.VISIBLE);
                        } else {
                            tvRespond.setVisibility(View.INVISIBLE);
                        }
                    }

                }

                @Override
                public void onPageSelected(int position) {

                }

                @Override
                public void onPageScrollStateChanged(int state) {

                }
            });
            llNewReview.setOnClickListener(v -> {
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.replace(getId(), ReviewListFragment.getInstance(), "Reviews");
                ft.addToBackStack("reviews");
                ft.commit();
            });
            llRespond.setOnClickListener(v -> {
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.replace(getId(), ReviewListFragment.getInstance(), "Reviews");
                ft.addToBackStack("reviews");
                ft.commit();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        new Thread(this::fetchReviews).start();
    }

    private void fetchReviews() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id);
            AndroidNetworking.get(ApiEndPoints.reviews + "home/")
                    .addQueryParameter(params)
                    .build()
                    .getAsObject(ReviewModel.class, new ParsedRequestListener<ReviewModel>() {
                        @Override
                        public void onResponse(ReviewModel response) {
                            try {
                                reviewModel = response;
                                if (reviewModel.last_reviews != null) {
                                    reviewArrayList.clear();
                                    reviewArrayList.addAll(reviewModel.last_reviews);
                                    vpAdapter.notifyDataSetChanged();
                                    viewPagerIndicator.setViewPager(vpRecentReview, reviewArrayList.size());
                                    setUpViews();
                                }
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                    llNoRecords.setVisibility(View.VISIBLE);
                                });
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpViews() {
        try {
            if (reviewModel != null) {
                tvViewAll.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
                tvRecentView.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
                if (!Validators.isNullOrEmpty(reviewModel.final_review)) {
                    tvAvgReview.setText(MyApp.df.format(reviewModel.final_review) + "/5");
                    rbAvgRatings.setRating(reviewModel.final_review);
                } else {
                    tvAvgReview.setText("0/0");
                }

                tvAvgTotalReviews.setText(reviewModel.total_rating + " total reviews");
                if (reviewModel.new_review_count > 0) {
                    rlAvgUnreadCount.setVisibility(View.VISIBLE);
                    tvAvgMessageCount.setText(String.valueOf(reviewModel.new_review_count));

                    rlRecentUnreadCount.setVisibility(View.VISIBLE);
                    tvRecentMessageCount.setText(String.valueOf(reviewModel.new_review_count));
                    tvAvgNewReview.setText("New Review " + "(" + reviewModel.new_review_count + ")");
                    tvRecentView.setText("View");
                } else {
                    rlAvgUnreadCount.setVisibility(View.GONE);
                    rlRecentUnreadCount.setVisibility(View.GONE);
                    tvViewAll.setText("View all");
                    tvAvgNewReview.setVisibility(View.INVISIBLE);

                    llNewReview.setBackgroundResource(R.drawable.bottom_rounded_filled_grey);

                    tvRecentView.setText("View all");
                    llRespond.setBackgroundResource(R.drawable.bottom_rounded_filled_grey);

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openResponceBottomsheet() {
        try {
            ReviewResponseFragment reviewResponseFragment = ReviewResponseFragment.getInstance((LatestReviewModel) reviewArrayList.get(vpRecentReview.getCurrentItem()));
            reviewResponseFragment.show(getChildFragmentManager(), "response");
            reviewResponseFragment.setDialogDismissListener(new DialogDismissListener() {
                @Override
                public void onDialogDismiss(Object o) {
                    fetchData();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            llMainLayout = view.findViewById(R.id.llMainLayout);
            tvAvgReview = view.findViewById(R.id.tvRating);
            tvAvgTotalReviews = view.findViewById(R.id.tvTotalreview);
            rlAvgUnreadCount = view.findViewById(R.id.rlAvgUnreadCount);
            tvAvgMessageCount = view.findViewById(R.id.tvAvgUnreadCount);
            rlRecentUnreadCount = view.findViewById(R.id.rlUnreadCount);
            tvRecentMessageCount = view.findViewById(R.id.tvRecentUnreadCount);
            rbAvgRatings = view.findViewById(R.id.rating);
            tvViewAll = view.findViewById(R.id.tvViewAll);
            tvAvgNewReview = view.findViewById(R.id.tvAvgNewReview);
            llNewReview = view.findViewById(R.id.llNewReview);
            tvRespond = view.findViewById(R.id.tvRespond);
            tvRecentView = view.findViewById(R.id.tvViewRecent);
            llRespond = view.findViewById(R.id.llRespond);
            llNoRecords = view.findViewById(R.id.llNoRecord);
            llLoading = view.findViewById(R.id.llLoading);
            vpRecentReview = view.findViewById(R.id.vpReview);
            viewPagerIndicator = view.findViewById(R.id.circleIndicator);
            vpAdapter = new RecentReviewViewPagerAdapter(getActivity(), reviewArrayList);
            vpRecentReview.setAdapter(vpAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
