package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.ReviewAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.interfaces.RecyclerItemViewClickListener;
import com.tiffintom.partner1.models.LatestReviewModel;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReviewListFragment extends BaseFragment {

    private RecyclerView rvReview;
    private ReviewAdapter reviewAdapter;
    private ArrayList<Object> reviewList = new ArrayList<>();
    private LinearLayout llNoRecored, llLoading;
    private LatestReviewModel latestReviewModel;
    private ImageView ivBack;

    public static ReviewListFragment getInstance() {
        return new ReviewListFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_review_list, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        fetchData();
        setListeners();
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    private void fetchData() {
        new Thread(this::fetchReviewList).start();
    }

    private void fetchReviewList() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id);
            params.put("nopaginate", "1");
            AndroidNetworking.get(ApiEndPoints.reviews)
                    .addQueryParameter(params)
                    // .addBodyParameter("action", "Reviewall")
                    .build()
                    .getAsObjectList(LatestReviewModel.class, new ParsedRequestListener<List<LatestReviewModel>>() {
                        @Override
                        public void onResponse(List<LatestReviewModel> response) {
                            try {
                                reviewList.clear();
                                reviewList.addAll(response);
                                reviewAdapter.notifyDataSetChanged();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llNoRecored.setVisibility(View.VISIBLE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            rvReview = view.findViewById(R.id.rvReview);
            llNoRecored = view.findViewById(R.id.llNoRecord);
            llLoading = view.findViewById(R.id.llLoading);
            ivBack = view.findViewById(R.id.ivBack);

            reviewAdapter = new ReviewAdapter(getActivity(), reviewList, new RecyclerItemViewClickListener() {
                @Override
                public void onItemClick(View view, int position, Object data) {
                    latestReviewModel = (LatestReviewModel) data;
                    openResponceBottomsheet(latestReviewModel);
                }
            });
            rvReview.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvReview.setNestedScrollingEnabled(false);
            rvReview.setAdapter(reviewAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openResponceBottomsheet(LatestReviewModel latestReviewModel) {
        try {
            ReviewResponseFragment reviewResponseFragment = ReviewResponseFragment.getInstance(latestReviewModel);
            reviewResponseFragment.show(getChildFragmentManager(), "response");
            reviewResponseFragment.setDialogDismissListener(new DialogDismissListener() {
                @Override
                public void onDialogDismiss(Object o) {
                    fetchData();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
