package com.tiffintom.partner1.fragments;

import static com.tiffintom.partner1.utils.Constants.TAPTOPAY;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.stripe.stripeterminal.external.models.Reader;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.CardReaderAdapter;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.MerchantCardReader;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Amrish on 07-12-2020.
 */
public class SelectCardReaderDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title, info;
    private DialogDismissListener dialogDismissListener;
    private MaterialButton btnConfirm, btnCancel;
    private MerchantCardReader selectedCardReader;
    private Reader stripeReader;
    private RecyclerView rvReaders;
    private CardReaderAdapter cardReaderAdapter;
    private ArrayList<Object> cardReaders = new ArrayList<>();
    private boolean stripe = false;
    protected MerchantBusinesses merchantBusiness = MyApp.getInstance().getMyPreferences().getMerchantBusinesses();

    public static SelectCardReaderDialogFragment getInstance() {
        SelectCardReaderDialogFragment rejectReasonDialog = new SelectCardReaderDialogFragment();
        Bundle bundle = new Bundle();
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public static SelectCardReaderDialogFragment getInstance(ArrayList<Reader> terminalReaders, boolean stripe) {
        SelectCardReaderDialogFragment rejectReasonDialog = new SelectCardReaderDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("readers", new Gson().toJson(terminalReaders));
        bundle.putBoolean("stripe", true);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_select_cardreader, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                ArrayList<Object> cr = new Gson().fromJson(getArguments().getString("readers"), new TypeToken<List<Reader>>() {
                }.getType());
                if (cr != null && cr.size() > 0) cardReaders.addAll(cr);
                stripe = getArguments().getBoolean("stripe");
            }
            selectedCardReader = MyApp.getInstance().getMyPreferences().getDefaultCardReader();
            initViews(view);
            setListeners();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            rvReaders = view.findViewById(R.id.rvCardReaders);

            if (!stripe){
                ArrayList<MerchantCardReader> card_readers = merchantBusiness.card_readers;
                // remove tap to pay from list if getting false in tap_to_pay
                if(!MyApp.getInstance().getMyPreferences().getDeviceRegistration().is_tap_to_pay){
                    for (int i=0; i<card_readers.size(); i++){
                        MerchantCardReader obj = card_readers.get(i);
                        if(obj.connectivity!=null && !obj.connectivity.equalsIgnoreCase(TAPTOPAY)){
                            cardReaders.add(obj);
                        }
                    }
                }
                else{
                    cardReaders.addAll(merchantBusiness.card_readers);
                }
            }
            cardReaderAdapter = new CardReaderAdapter(cardReaders, (position, data) -> {
                if (data instanceof MerchantCardReader) {
                    selectedCardReader = (MerchantCardReader) data;
                    btnConfirm.setEnabled(true);
                } else if (data instanceof Reader) {
                    stripeReader = (Reader) data;
                    btnConfirm.setEnabled(true);
                }
            });
            rvReaders.setAdapter(cardReaderAdapter);
            rvReaders.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            if (!stripe && selectedCardReader != null) {
                cardReaderAdapter.selectedId = selectedCardReader.id;
                cardReaderAdapter.notifyDataSetChanged();
                btnConfirm.setEnabled(true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (stripe && stripeReader == null) {
                    ToastUtils.makeSnackToast(getActivity(), "Please select card reader");
                    return;
                }
                if (!stripe && selectedCardReader == null) {
                    ToastUtils.makeSnackToast(getActivity(), "Please select card reader");
                    return;
                }
                if (dialogDismissListener != null) {
                    if (stripe) dialogDismissListener.onDialogDismiss(stripeReader);
                    else dialogDismissListener.onDialogDismiss(selectedCardReader);
                }
                dismiss();
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(null);
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
