package com.tiffintom.partner1.fragments;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.SplashActivity;
import com.tiffintom.partner1.adapters.CountryAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.Country;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.ArrayList;

/**
 * Created by Amrish on 11-09-2020.
 */
public class SelectCountryFragment extends BaseFragment {
    private LinearLayout llUk, llIndia;
    private TextView tvIndia, tvUk;
    private String selectedCountry = "UK";
    private FloatingActionButton fabNext;
    private ImageView ivUk, ivIndia;
    private ArrayList<Country> countries = new ArrayList<>();
    private TextView tvSelectedCountry;
    private CardView cvCountry;
    private LinearLayout llNext;

    public static SelectCountryFragment getInstance() {
        return new SelectCountryFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_select_country, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            selectedCountry = myApp.getMyPreferences().getSelectedCountry();
            setListeners();
            updateViews();
            setUpCountries();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            if (myApp.getMyPreferences().getSelectedCountry() != null) {
                llNext.setEnabled(true);
                if (myApp.getMyPreferences().getSelectedCountry().equalsIgnoreCase("in")) {
                    tvSelectedCountry.setText("India");
                } else if (myApp.getMyPreferences().getSelectedCountry().equalsIgnoreCase("uk")) {
                    tvSelectedCountry.setText("United Kingdom");
                }
            } else {
                tvSelectedCountry.setHint("Select your country");
                llNext.setEnabled(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            llNext = view.findViewById(R.id.llNext);
            cvCountry = view.findViewById(R.id.cvCountry);
            tvSelectedCountry = view.findViewById(R.id.tvSelectedCountry);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpCountries() {
        countries.clear();
        countries.add(new Country("United Kingdom", "UK", 0, 0));
        countries.add(new Country("India", "IN", 0, 0));
    }

    private void setListeners() {
        cvCountry.setOnClickListener(view -> {
            openPopup();
        });

        llNext.setOnClickListener(view -> {
            if (!Validators.isNullOrEmpty(selectedCountry)) {
                myApp.getMyPreferences().saveSelectedCountry(selectedCountry);
                startActivity(new Intent(getActivity(), SplashActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
            } else {
                ToastUtils.makeToast(getActivity(), "Please select country to continue");
            }
        });
    }

    PopupWindow changeSortPopUp;

    private void openPopup() {
        try {
            LinearLayout viewGroup = getActivity().findViewById(R.id.llPopup);
            LayoutInflater layoutInflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            View layout = layoutInflater.inflate(R.layout.popup_select_country, viewGroup);

            // Creating the PopupWindow
            changeSortPopUp = new PopupWindow(getActivity());
            changeSortPopUp.setContentView(layout);
            changeSortPopUp.setWidth(LinearLayout.LayoutParams.MATCH_PARENT);
            changeSortPopUp.setHeight(LinearLayout.LayoutParams.WRAP_CONTENT);
            changeSortPopUp.setFocusable(true);
            changeSortPopUp.setWindowLayoutMode(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            changeSortPopUp.setBackgroundDrawable(new ColorDrawable());
            RecyclerView rvCountries = layout.findViewById(R.id.rvCountries);
            TextView tvSelectCountry = layout.findViewById(R.id.tvCountryText);
            tvSelectCountry.setOnClickListener(view -> changeSortPopUp.dismiss());
            int location[] = new int[2];
            cvCountry.getLocationOnScreen(location);
            CountryAdapter countryAdapter = null;
            countryAdapter = new CountryAdapter(countries, selectedCountry, (view1, position, data) -> {
                rvCountries.setVisibility(View.GONE);
                selectedCountry = ((Country) data).smallName;
                tvSelectedCountry.setText(((Country) data).name);
                llNext.setEnabled(true);
                changeSortPopUp.dismiss();
            });
            rvCountries.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvCountries.setAdapter(countryAdapter);
            changeSortPopUp.showAtLocation(cvCountry, Gravity.NO_GRAVITY,
                    location[0], (int) cvCountry.getY() + 18);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
