package com.tiffintom.partner1.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.activities.TransportActivity;
import com.tiffintom.partner1.adapters.RecentOrdersAdapter;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.OrderDetail;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;


/**
 * Created by Amrish on 13-11-2020.
 */
public class SelectCustomerBottomSheetFragment extends BaseBottomSheet {
    public static SelectCustomerBottomSheetFragment getInstance() {
        return new SelectCustomerBottomSheetFragment();
    }

    private RecyclerView rvCustomers;
    private AppCompatEditText etSearch;

    private RecentOrdersAdapter orderHistoryAdapter;
    private ArrayList<OrderDetail> orders = new ArrayList<>();
    private ArrayList<OrderDetail> searchedOrders = new ArrayList<>();
    private TextView tvRecentOrders;
    private LottieAnimationView loadingView;
    private RestaurantUser loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
    private final Calendar toCalendar = Calendar.getInstance();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_select_customer_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListener();
        fetchData();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            ivClose = view.findViewById(R.id.ivClose);
            rvCustomers = view.findViewById(R.id.rvCustomers);
            etSearch = view.findViewById(R.id.etSearch);
            loadingView = view.findViewById(R.id.lodingView);
            orderHistoryAdapter = new RecentOrdersAdapter(searchedOrders, (position, data) -> {
                try {
                    if (data instanceof OrderDetail) {
                        OrderDetail orderHistory = (OrderDetail) data;
                        startActivity(new Intent(getActivity(), TransportActivity.class).putExtra("order_id", orderHistory.id).putExtra("customer_name",orderHistory.customer_name).putExtra("customer_phone", orderHistory.customer_phone).putExtra("customer_id",  String.valueOf(orderHistory.customer_id)).putExtra("destination", "chat"));
                        dismiss();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rvCustomers.setLayoutManager(new LinearLayoutManager(getActivity()));
            rvCustomers.setAdapter(orderHistoryAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListener() {
        super.setListeners();
        try {
            etSearch.setOnKeyListener((textView, i, keyEvent) -> {
                if (keyEvent.getAction() != KeyEvent.ACTION_DOWN)
                    return true;
                if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                    getActivity().onBackPressed();
                } else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                    searchedOrders.clear();
                    searchedOrders.addAll(searchChat());
                    orderHistoryAdapter.notifyDataSetChanged();
                    CommonFunctions.hideKeyboard(getActivity(), etSearch);
                }
                return false;
            });
            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    searchedOrders.clear();
                    searchedOrders.addAll(searchChat());
                    orderHistoryAdapter.notifyDataSetChanged();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        new Thread(this::getRecentCustomerOrders).start();
    }

    private void getRecentCustomerOrders() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> loadingView.setVisibility(View.VISIBLE));
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id);
            params.put("customer_id", myApp.getMyPreferences().getLoggedInRestaurant().customer_id);
            params.put("nopaginate", "1");
            params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"));
            params.put("from_date", CommonFunctions.getPreviousDate(CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd").replace("/", "-"), -2));
            AndroidNetworking.get(ApiEndPoints.orders).addQueryParameter(params)
                    .build()
                    .getAsObjectList(OrderDetail.class, new ParsedRequestListener<List<OrderDetail>>() {
                        @Override
                        public void onResponse(List<OrderDetail> response) {
                            try {
                                orders.clear();
                                orders.addAll(response);
                                searchedOrders.clear();
                                searchedOrders.addAll(orders);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    loadingView.setVisibility(View.GONE);
                                    orderHistoryAdapter.notifyDataSetChanged();
                                });
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> loadingView.setVisibility(View.GONE));
                                }
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<OrderDetail> searchChat() {
        if (etSearch.getText().toString().isEmpty()) {
            return orders;
        }
        ArrayList<OrderDetail> searchedRest = new ArrayList<>();
        for (OrderDetail r : orders) {
            if (r.customer_name != null && r.customer_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                searchedRest.add(r);
            }
        }
        return searchedRest;

    }

    @Override
    public void onStop() {
        try {
            CommonFunctions.hideKeyboard(getActivity(), etSearch);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }
}
