package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.AutoDiscountAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.Offer;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Amrish on 14-12-2020.
 */
public class SettingsAutoDiscountFragment extends BaseFragment {
    public static SettingsAutoDiscountFragment getInstance() {
        return new SettingsAutoDiscountFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    private RecyclerView rvAutoDiscounts;
    private AutoDiscountAdapter autoDiscountAdapter;
    private ArrayList<Offer> offers = new ArrayList<>();
    private ArrayList<Offer> removedOffers = new ArrayList<>();
    private MaterialCardView cvAdd;
    private LinearLayout llMainLayout;
    private MaterialButton btnUpdate;
    private ImageView ivBack;

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        rvAutoDiscounts = view.findViewById(R.id.rvAutoDiscounts);
        cvAdd = view.findViewById(R.id.cvAdd);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        ivBack = view.findViewById(R.id.ivBack);

        autoDiscountAdapter = new AutoDiscountAdapter(offers, (position, data) -> {
            Offer offer = (Offer) data;
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(String.valueOf(offer.normal_percentage), "Enter discount percentage");
            enterAmountDialogFragment.show(getChildFragmentManager(), "enter_discount");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    offer.normal_percentage = Float.parseFloat((String) o);
                    offers.set(position, offer);
                    autoDiscountAdapter.notifyDataSetChanged();
                }
            });
        }, (position, data) -> {
            Offer offer = (Offer) data;
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(String.valueOf(offer.normal_price), "Enter order value");
            enterAmountDialogFragment.show(getChildFragmentManager(), "order_value");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    offer.normal_price = Float.parseFloat((String) o);
                    offers.set(position, offer);
                    autoDiscountAdapter.notifyDataSetChanged();
                }
            });
        }, (position, data) -> {
            removedOffers.add((Offer) data);
        });
        rvAutoDiscounts.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvAutoDiscounts.setAdapter(autoDiscountAdapter);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_autodiscounts, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        getOffers();
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
        cvAdd.setOnClickListener(view -> {
            Offer offer = new Offer();
            offer.free_percentage=0;
            offer.free_price=0;
            offer.first_user="N";
            offer.offer_mode="flat";
            offers.add(offer);
            autoDiscountAdapter.notifyDataSetChanged();
            if (offers.size() > 0) {
                btnUpdate.setVisibility(View.VISIBLE);
                btnUpdate.setEnabled(true);
            }
        });
        btnUpdate.setOnClickListener(view -> {
            boolean isValid = true;
            for (Offer offer : offers) {
                if ((offer.normal_percentage) == 0 || (offer.normal_price) == 0) {
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Invalid offer details");
                    isValid = false;
                    break;
                }
                if ((!offer.delivery_type && !offer.pickup_type && !offer.dinein_type)) {
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please select order type");
                    isValid = false;
                    break;
                }
            }
            if (isValid) {
                updateOffers();
            }
        });

    }

    private void getOffers() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", loggedInRestaurant.id);
            params.put("nopaginate", "1");
            AndroidNetworking.get(ApiEndPoints.offers).addQueryParameter(params)
                    .build()
                    .getAsObjectList(Offer.class, new ParsedRequestListener<List<Offer>>() {
                        @Override
                        public void onResponse(List<Offer> response) {
                            try {
                                offers.clear();
                                removedOffers.clear();
                                offers.addAll(response);
                                autoDiscountAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                cvAdd.setVisibility(View.VISIBLE);
                                if (offers.size() > 0) {
                                    btnUpdate.setVisibility(View.VISIBLE);
                                }
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateOffers() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            ArrayList<Offer> allOffers = new ArrayList<>();
            allOffers.addAll(offers);
            allOffers.addAll(removedOffers);

            HashMap<String, String> params = new HashMap<>();
            params.put("offers", new Gson().toJson(allOffers));

            AndroidNetworking.post(ApiEndPoints.offers+"bulk")
                    .addApplicationJsonBody(params)
                    .build()
                    .getAsObjectList(Offer.class, new ParsedRequestListener<List<Offer>>() {
                        @Override
                        public void onResponse(List<Offer> response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Offers updated successfully.");
                                getOffers();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
