package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;

public class SettingsBankDetailsFragment extends BaseFragment {

    private TextView tvBankName, tvBankAccountNumber, tvBankCode, tvAccountName, tvAccountType;
    private ImageView ivBack;

    public static SettingsBankDetailsFragment getInstance() {
        return new SettingsBankDetailsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_bankdetails, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        tvBankAccountNumber = view.findViewById(R.id.tvBankAccountNumber);
        tvAccountName = view.findViewById(R.id.tvAccountName);
        tvAccountType = view.findViewById(R.id.tvAccountType);
        tvBankCode = view.findViewById(R.id.tvBankSortCode);
        tvBankName = view.findViewById(R.id.tvBankName);
        ivBack = view.findViewById(R.id.ivBack);

        try {
            if (loggedInRestaurant.bank_detail !=null&&loggedInRestaurant.bank_detail.bank_name!=null) {
                tvBankName.setText(loggedInRestaurant.bank_detail.bank_name);
            }
            if (loggedInRestaurant.bank_detail !=null&&loggedInRestaurant.bank_detail.account_name!=null) {
                tvAccountName.setText(loggedInRestaurant.bank_detail.account_name);
            }
            if (loggedInRestaurant.bank_detail !=null&&loggedInRestaurant.bank_detail.account_number!=null) {
                tvBankAccountNumber.setText(loggedInRestaurant.bank_detail.account_number);
            }
            if (loggedInRestaurant.bank_detail !=null&&loggedInRestaurant.bank_detail.account_type!=null) {
                tvAccountType.setText(loggedInRestaurant.bank_detail.account_type);
            }
            if (loggedInRestaurant.bank_detail !=null&&loggedInRestaurant.bank_detail.sort_code!=null) {
                tvBankCode.setText(loggedInRestaurant.bank_detail.sort_code);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
