package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.jaygoo.widget.OnRangeChangedListener;
import com.jaygoo.widget.RangeSeekBar;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.interfaces.FilterDialogDismissListener;
import com.tiffintom.partner1.models.RestaurantTiming;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

/**
 * Created by Amrish on 24-12-2020.
 */
public class SettingsCollectionHoursFragment extends BaseFragment {
    public static SettingsCollectionHoursFragment getInstance() {
        return new SettingsCollectionHoursFragment();
    }

    RangeSeekBar rangeMondayM;
    RangeSeekBar rangeTuesdayM;
    RangeSeekBar rangeWednesdayM;
    RangeSeekBar rangeThursdayM;
    RangeSeekBar rangeFridayM;
    RangeSeekBar rangeSaturdayM;
    RangeSeekBar rangeSundayM;

    SwitchCompat swMondayM;
    SwitchCompat swTuesdayM;
    SwitchCompat swWednesdayM;
    SwitchCompat swThursdayM;
    SwitchCompat swFridayM;
    SwitchCompat swSaturdayM;
    SwitchCompat swSundayM;

    TextView tvEditMondayM, tvMondayM;
    TextView tvEditTuesdayM, tvTuesdayM;
    TextView tvEditWednesdayM, tvWednesdayM;
    TextView tvEditThursdayM, tvThursdayM;
    TextView tvEditFridayM, tvFridayM;
    TextView tvEditSaturdayM, tvSaturdayM;
    TextView tvEditSundayM, tvSundayM;

    LinearLayout llMondayM;
    LinearLayout llTuesdayM;
    LinearLayout llWednesdayM;
    LinearLayout llThursdayM;
    LinearLayout llFridayM;
    LinearLayout llSaturdayM;
    LinearLayout llSundayM;

    RangeSeekBar rangeMondayE;
    RangeSeekBar rangeTuesdayE;
    RangeSeekBar rangeWednesdayE;
    RangeSeekBar rangeThursdayE;
    RangeSeekBar rangeFridayE;
    RangeSeekBar rangeSaturdayE;
    RangeSeekBar rangeSundayE;

    SwitchCompat swMondayE;
    SwitchCompat swTuesdayE;
    SwitchCompat swWednesdayE;
    SwitchCompat swThursdayE;
    SwitchCompat swFridayE;
    SwitchCompat swSaturdayE;
    SwitchCompat swSundayE;

    TextView tvEditMondayE, tvMondayE;
    TextView tvEditTuesdayE, tvTuesdayE;
    TextView tvEditWednesdayE, tvWednesdayE;
    TextView tvEditThursdayE, tvThursdayE;
    TextView tvEditFridayE, tvFridayE;
    TextView tvEditSaturdayE, tvSaturdayE;
    TextView tvEditSundayE, tvSundayE;

    LinearLayout llMondayE;
    LinearLayout llTuesdayE;
    LinearLayout llWednesdayE;
    LinearLayout llThursdayE;
    LinearLayout llFridayE;
    LinearLayout llSaturdayE;
    LinearLayout llSundayE;

    View vMorning, vEvening;
    LinearLayout llMorning, llEvening;
    LinearLayout llMorningTab, llEveningTab;
    RestaurantTiming pickupTiming = loggedInRestaurant.restaurant_timing;

    MaterialButton btnUpdate;
    ImageView ivBack;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_collection_hours, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        rangeMorningListeners();
        rangeEveningListeners();
        switchListeners();
        setListeners();
        updateViews();
        updateTextViews();
        llEveningTab.setOnClickListener(view1 -> {
            llEvening.setVisibility(View.VISIBLE);
            llMorning.setVisibility(View.GONE);
            vEvening.setVisibility(View.VISIBLE);
            vMorning.setVisibility(View.INVISIBLE);
        });
        llMorningTab.setOnClickListener(view1 -> {
            llMorning.setVisibility(View.VISIBLE);
            llEvening.setVisibility(View.GONE);
            vMorning.setVisibility(View.VISIBLE);
            vEvening.setVisibility(View.INVISIBLE);
        });
        btnUpdate.setOnClickListener(view1 -> {
            try {
                saveDetails();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        });
        llMorningTab.performClick();


    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        btnUpdate = view.findViewById(R.id.btnUpdate);
        llMorningTab = view.findViewById(R.id.llMorningTab);
        llEveningTab = view.findViewById(R.id.llEveningTab);

        vEvening = view.findViewById(R.id.vEvening);
        vMorning = view.findViewById(R.id.vMorning);

        llMorning = view.findViewById(R.id.llMorning);
        llEvening = view.findViewById(R.id.llEvening);

        rangeMondayM = view.findViewById(R.id.rangeMondayM);
        tvMondayM = view.findViewById(R.id.tvMondayM);
        tvEditMondayM = view.findViewById(R.id.tvEditMondayM);
        swMondayM = view.findViewById(R.id.swMondayM);
        llMondayM = view.findViewById(R.id.llMondayM);

        rangeTuesdayM = view.findViewById(R.id.rangeTuesdayM);
        tvTuesdayM = view.findViewById(R.id.tvTuesdayM);
        tvEditTuesdayM = view.findViewById(R.id.tvEditTuesdayM);
        swTuesdayM = view.findViewById(R.id.swTuesdayM);
        llTuesdayM = view.findViewById(R.id.llTuesdayM);

        rangeWednesdayM = view.findViewById(R.id.rangeWednesdayM);
        tvWednesdayM = view.findViewById(R.id.tvWednesdayM);
        tvEditWednesdayM = view.findViewById(R.id.tvEditWednesdayM);
        swWednesdayM = view.findViewById(R.id.swWednesdayM);
        llWednesdayM = view.findViewById(R.id.llWednesdayM);

        rangeThursdayM = view.findViewById(R.id.rangeThursdayM);
        tvThursdayM = view.findViewById(R.id.tvThursdayM);
        tvEditThursdayM = view.findViewById(R.id.tvEditThursdayM);
        swThursdayM = view.findViewById(R.id.swThursdayM);
        llThursdayM = view.findViewById(R.id.llThursdayM);

        rangeFridayM = view.findViewById(R.id.rangeFridayM);
        tvFridayM = view.findViewById(R.id.tvFridayM);
        tvEditFridayM = view.findViewById(R.id.tvEditFridayM);
        swFridayM = view.findViewById(R.id.swFridayM);
        llFridayM = view.findViewById(R.id.llFridayM);

        rangeSaturdayM = view.findViewById(R.id.rangeSaturdayM);
        tvSaturdayM = view.findViewById(R.id.tvSaturdayM);
        tvEditSaturdayM = view.findViewById(R.id.tvEditSaturdayM);
        swSaturdayM = view.findViewById(R.id.swSaturdayM);
        llSaturdayM = view.findViewById(R.id.llSaturdayM);

        rangeSundayM = view.findViewById(R.id.rangeSundayM);
        tvSundayM = view.findViewById(R.id.tvSundayM);
        tvEditSundayM = view.findViewById(R.id.tvEditSundayM);
        swSundayM = view.findViewById(R.id.swSundayM);
        llSundayM = view.findViewById(R.id.llSundayM);

        rangeMondayE = view.findViewById(R.id.rangeMondayE);
        tvMondayE = view.findViewById(R.id.tvMondayE);
        tvEditMondayE = view.findViewById(R.id.tvEditMondayE);
        swMondayE = view.findViewById(R.id.swMondayE);
        llMondayE = view.findViewById(R.id.llMondayE);

        rangeTuesdayE = view.findViewById(R.id.rangeTuesdayE);
        tvTuesdayE = view.findViewById(R.id.tvTuesdayE);
        tvEditTuesdayE = view.findViewById(R.id.tvEditTuesdayE);
        swTuesdayE = view.findViewById(R.id.swTuesdayE);
        llTuesdayE = view.findViewById(R.id.llTuesdayE);

        rangeWednesdayE = view.findViewById(R.id.rangeWednesdayE);
        tvWednesdayE = view.findViewById(R.id.tvWednesdayE);
        tvEditWednesdayE = view.findViewById(R.id.tvEditWednesdayE);
        swWednesdayE = view.findViewById(R.id.swWednesdayE);
        llWednesdayE = view.findViewById(R.id.llWednesdayE);

        rangeThursdayE = view.findViewById(R.id.rangeThursdayE);
        tvThursdayE = view.findViewById(R.id.tvThursdayE);
        tvEditThursdayE = view.findViewById(R.id.tvEditThursdayE);
        swThursdayE = view.findViewById(R.id.swThursdayE);
        llThursdayE = view.findViewById(R.id.llThursdayE);

        rangeFridayE = view.findViewById(R.id.rangeFridayE);
        tvFridayE = view.findViewById(R.id.tvFridayE);
        tvEditFridayE = view.findViewById(R.id.tvEditFridayE);
        swFridayE = view.findViewById(R.id.swFridayE);
        llFridayE = view.findViewById(R.id.llFridayE);

        rangeSaturdayE = view.findViewById(R.id.rangeSaturdayE);
        tvSaturdayE = view.findViewById(R.id.tvSaturdayE);
        tvEditSaturdayE = view.findViewById(R.id.tvEditSaturdayE);
        swSaturdayE = view.findViewById(R.id.swSaturdayE);
        llSaturdayE = view.findViewById(R.id.llSaturdayE);

        rangeSundayE = view.findViewById(R.id.rangeSundayE);
        tvSundayE = view.findViewById(R.id.tvSundayE);
        tvEditSundayE = view.findViewById(R.id.tvEditSundayE);
        swSundayE = view.findViewById(R.id.swSundayE);
        llSundayE = view.findViewById(R.id.llSundayE);

        ivBack = view.findViewById(R.id.ivBack);
    }

    private void updateViews() {
        rangeMondayM.setProgress(convertToMinutes(pickupTiming.pick_monday_first_opentime), convertToMinutes(pickupTiming.pick_monday_first_closetime));
        rangeTuesdayM.setProgress(convertToMinutes(pickupTiming.pick_tuesday_first_opentime), convertToMinutes(pickupTiming.pick_tuesday_first_closetime));
        rangeWednesdayM.setProgress(convertToMinutes(pickupTiming.pick_wednesday_first_opentime), convertToMinutes(pickupTiming.pick_wednesday_first_closetime));
        rangeThursdayM.setProgress(convertToMinutes(pickupTiming.pick_thursday_first_opentime), convertToMinutes(pickupTiming.pick_thursday_first_closetime));
        rangeFridayM.setProgress(convertToMinutes(pickupTiming.pick_friday_first_opentime), convertToMinutes(pickupTiming.pick_friday_first_closetime));
        rangeSaturdayM.setProgress(convertToMinutes(pickupTiming.pick_saturday_first_opentime), convertToMinutes(pickupTiming.pick_saturday_first_closetime));
        rangeSundayM.setProgress(convertToMinutes(pickupTiming.pick_sunday_first_opentime), convertToMinutes(pickupTiming.pick_sunday_first_closetime));

        swMondayM.setChecked(!pickupTiming.pick_monday_status.equalsIgnoreCase("close"));
        swTuesdayM.setChecked(!pickupTiming.pick_tuesday_status.equalsIgnoreCase("close"));
        swWednesdayM.setChecked(!pickupTiming.pick_wednesday_status.equalsIgnoreCase("close"));
        swThursdayM.setChecked(!pickupTiming.pick_thursday_status.equalsIgnoreCase("close"));
        swFridayM.setChecked(!pickupTiming.pick_friday_status.equalsIgnoreCase("close"));
        swSaturdayM.setChecked(!pickupTiming.pick_saturday_status.equalsIgnoreCase("close"));
        swSundayM.setChecked(!pickupTiming.pick_sunday_status.equalsIgnoreCase("close"));

        rangeMondayE.setProgress(convertToMinutes(pickupTiming.pick_monday_second_opentime), convertToMinutes(pickupTiming.pick_monday_second_closetime));
        rangeTuesdayE.setProgress(convertToMinutes(pickupTiming.pick_tuesday_second_opentime), convertToMinutes(pickupTiming.pick_tuesday_second_closetime));
        rangeWednesdayE.setProgress(convertToMinutes(pickupTiming.pick_wednesday_second_opentime), convertToMinutes(pickupTiming.pick_wednesday_second_closetime));
        rangeThursdayE.setProgress(convertToMinutes(pickupTiming.pick_thursday_second_opentime), convertToMinutes(pickupTiming.pick_thursday_second_closetime));
        rangeFridayE.setProgress(convertToMinutes(pickupTiming.pick_friday_second_opentime), convertToMinutes(pickupTiming.pick_friday_second_closetime));
        rangeSaturdayE.setProgress(convertToMinutes(pickupTiming.pick_saturday_second_opentime), convertToMinutes(pickupTiming.pick_saturday_second_closetime));
        rangeSundayE.setProgress(convertToMinutes(pickupTiming.pick_sunday_second_opentime), convertToMinutes(pickupTiming.pick_sunday_second_closetime));

        swMondayE.setChecked(!pickupTiming.pick_monday_status.equalsIgnoreCase("close"));
        swTuesdayE.setChecked(!pickupTiming.pick_tuesday_status.equalsIgnoreCase("close"));
        swWednesdayE.setChecked(!pickupTiming.pick_wednesday_status.equalsIgnoreCase("close"));
        swThursdayE.setChecked(!pickupTiming.pick_thursday_status.equalsIgnoreCase("close"));
        swFridayE.setChecked(!pickupTiming.pick_friday_status.equalsIgnoreCase("close"));
        swSaturdayE.setChecked(!pickupTiming.pick_saturday_status.equalsIgnoreCase("close"));
        swSundayE.setChecked(!pickupTiming.pick_sunday_status.equalsIgnoreCase("close"));
    }

    private void updateTextViews() {
        tvMondayM.setText(pickupTiming.pick_monday_first_opentime + " - " + pickupTiming.pick_monday_first_closetime);
        tvTuesdayM.setText(pickupTiming.pick_tuesday_first_opentime + " - " + pickupTiming.pick_tuesday_first_closetime);
        tvWednesdayM.setText(pickupTiming.pick_wednesday_first_opentime + " - " + pickupTiming.pick_wednesday_first_closetime);
        tvThursdayM.setText(pickupTiming.pick_thursday_first_opentime + " - " + pickupTiming.pick_thursday_first_closetime);
        tvFridayM.setText(pickupTiming.pick_friday_first_opentime + " - " + pickupTiming.pick_friday_first_closetime);
        tvSaturdayM.setText(pickupTiming.pick_saturday_first_opentime + " - " + pickupTiming.pick_saturday_first_closetime);
        tvSundayM.setText(pickupTiming.pick_sunday_first_opentime + " - " + pickupTiming.pick_sunday_first_closetime);

        tvMondayE.setText(pickupTiming.pick_monday_second_opentime + " - " + pickupTiming.pick_monday_second_closetime);
        tvTuesdayE.setText(pickupTiming.pick_tuesday_second_opentime + " - " + pickupTiming.pick_tuesday_second_closetime);
        tvWednesdayE.setText(pickupTiming.pick_wednesday_second_opentime + " - " + pickupTiming.pick_wednesday_second_closetime);
        tvThursdayE.setText(pickupTiming.pick_thursday_second_opentime + " - " + pickupTiming.pick_thursday_second_closetime);
        tvFridayE.setText(pickupTiming.pick_friday_second_opentime + " - " + pickupTiming.pick_friday_second_closetime);
        tvSaturdayE.setText(pickupTiming.pick_saturday_second_opentime + " - " + pickupTiming.pick_saturday_second_closetime);
        tvSundayE.setText(pickupTiming.pick_sunday_second_opentime + " - " + pickupTiming.pick_sunday_second_closetime);
    }

    private void rangeMorningListeners() {
        rangeMondayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_monday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_monday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeTuesdayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_tuesday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_tuesday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeWednesdayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_wednesday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_wednesday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeThursdayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_thursday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_thursday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeFridayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_friday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_friday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeSaturdayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_saturday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_saturday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeSundayM.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_sunday_first_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_sunday_first_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });

        tvEditMondayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set monday morning time", pickupTiming.pick_monday_first_opentime, pickupTiming.pick_monday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_monday_first_opentime = from;
                    pickupTiming.pick_monday_first_closetime = to;
                    updateTextViews();
                    rangeMondayM.setProgress(convertToMinutes(pickupTiming.pick_monday_first_opentime), convertToMinutes(pickupTiming.pick_monday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditTuesdayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set tuesday morning time", pickupTiming.pick_tuesday_first_opentime, pickupTiming.pick_tuesday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_tuesday_first_opentime = from;
                    pickupTiming.pick_tuesday_first_closetime = to;
                    updateTextViews();
                    rangeTuesdayM.setProgress(convertToMinutes(pickupTiming.pick_tuesday_first_opentime), convertToMinutes(pickupTiming.pick_tuesday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditWednesdayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set wednesday morning time", pickupTiming.pick_wednesday_first_opentime, pickupTiming.pick_wednesday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_wednesday_first_opentime = from;
                    pickupTiming.pick_wednesday_first_closetime = to;
                    updateTextViews();
                    rangeWednesdayM.setProgress(convertToMinutes(pickupTiming.pick_wednesday_first_opentime), convertToMinutes(pickupTiming.pick_wednesday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditThursdayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set thursday morning time", pickupTiming.pick_thursday_first_opentime, pickupTiming.pick_thursday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_thursday_first_opentime = from;
                    pickupTiming.pick_thursday_first_closetime = to;
                    updateTextViews();
                    rangeThursdayM.setProgress(convertToMinutes(pickupTiming.pick_thursday_first_opentime), convertToMinutes(pickupTiming.pick_thursday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditFridayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set friday morning time", pickupTiming.pick_friday_first_opentime, pickupTiming.pick_friday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_friday_first_opentime = from;
                    pickupTiming.pick_friday_first_closetime = to;
                    updateTextViews();
                    rangeFridayM.setProgress(convertToMinutes(pickupTiming.pick_friday_first_opentime), convertToMinutes(pickupTiming.pick_friday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditSaturdayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set saturday morning time", pickupTiming.pick_saturday_first_opentime, pickupTiming.pick_saturday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_saturday_first_opentime = from;
                    pickupTiming.pick_saturday_first_closetime = to;
                    updateTextViews();
                    rangeSaturdayM.setProgress(convertToMinutes(pickupTiming.pick_saturday_first_opentime), convertToMinutes(pickupTiming.pick_saturday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditSundayM.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set sunday morning time", pickupTiming.pick_sunday_first_opentime, pickupTiming.pick_sunday_first_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_sunday_first_opentime = from;
                    pickupTiming.pick_sunday_first_closetime = to;
                    updateTextViews();
                    rangeSundayM.setProgress(convertToMinutes(pickupTiming.pick_sunday_first_opentime), convertToMinutes(pickupTiming.pick_sunday_first_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });

    }

    private void rangeEveningListeners() {
        rangeMondayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_monday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_monday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeTuesdayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_tuesday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_tuesday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeWednesdayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_wednesday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_wednesday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeThursdayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_thursday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_thursday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeFridayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_friday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_friday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeSaturdayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_saturday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_saturday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        rangeSundayE.setOnRangeChangedListener(new OnRangeChangedListener() {
            @Override
            public void onRangeChanged(RangeSeekBar view, float leftValue, float rightValue, boolean isFromUser) {
                pickupTiming.pick_sunday_second_opentime = convertToHHMM(leftValue);
                pickupTiming.pick_sunday_second_closetime = convertToHHMM(rightValue);
                updateTextViews();
            }

            @Override
            public void onStartTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }

            @Override
            public void onStopTrackingTouch(RangeSeekBar view, boolean isLeft) {

            }
        });
        tvEditMondayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set monday evening time", pickupTiming.pick_monday_second_opentime, pickupTiming.pick_monday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_monday_second_opentime = from;
                    pickupTiming.pick_monday_second_closetime = to;
                    updateTextViews();
                    rangeMondayE.setProgress(convertToMinutes(pickupTiming.pick_monday_second_opentime), convertToMinutes(pickupTiming.pick_monday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditTuesdayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set tuesday evening time", pickupTiming.pick_tuesday_second_opentime, pickupTiming.pick_tuesday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_tuesday_second_opentime = from;
                    pickupTiming.pick_tuesday_second_closetime = to;
                    updateTextViews();
                    rangeTuesdayE.setProgress(convertToMinutes(pickupTiming.pick_tuesday_second_opentime), convertToMinutes(pickupTiming.pick_tuesday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditWednesdayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set wednesday evening time", pickupTiming.pick_wednesday_second_opentime, pickupTiming.pick_wednesday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_wednesday_second_opentime = from;
                    pickupTiming.pick_wednesday_second_closetime = to;
                    updateTextViews();
                    rangeWednesdayE.setProgress(convertToMinutes(pickupTiming.pick_wednesday_second_opentime), convertToMinutes(pickupTiming.pick_wednesday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditThursdayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set thursday evening time", pickupTiming.pick_thursday_second_opentime, pickupTiming.pick_thursday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_thursday_second_opentime = from;
                    pickupTiming.pick_thursday_second_closetime = to;
                    updateTextViews();
                    rangeThursdayE.setProgress(convertToMinutes(pickupTiming.pick_thursday_second_opentime), convertToMinutes(pickupTiming.pick_thursday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditFridayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set friday evening time", pickupTiming.pick_friday_second_opentime, pickupTiming.pick_friday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_friday_second_opentime = from;
                    pickupTiming.pick_friday_second_closetime = to;
                    updateTextViews();
                    rangeFridayE.setProgress(convertToMinutes(pickupTiming.pick_friday_second_opentime), convertToMinutes(pickupTiming.pick_friday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditSaturdayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set saturday evening time", pickupTiming.pick_saturday_second_opentime, pickupTiming.pick_saturday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_saturday_second_opentime = from;
                    pickupTiming.pick_saturday_second_closetime = to;
                    updateTextViews();
                    rangeSaturdayE.setProgress(convertToMinutes(pickupTiming.pick_saturday_second_opentime), convertToMinutes(pickupTiming.pick_saturday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });
        tvEditSundayE.setOnClickListener(view -> {

            TimeRangePickerFragment timeRangePickerFragment = TimeRangePickerFragment.getInstance("Set sunday evening time", pickupTiming.pick_sunday_second_opentime, pickupTiming.pick_sunday_second_closetime);
            timeRangePickerFragment.show(getActivity().getSupportFragmentManager(), "time");
            timeRangePickerFragment.setDialogDismissListener(new FilterDialogDismissListener() {
                @Override
                public void onDialogDismiss(Date from, Date to) {

                }

                @Override
                public void onDialogDismiss(String from, String to) {
                    pickupTiming.pick_sunday_second_opentime = from;
                    pickupTiming.pick_sunday_second_closetime = to;
                    updateTextViews();
                    rangeSundayE.setProgress(convertToMinutes(pickupTiming.pick_sunday_second_opentime), convertToMinutes(pickupTiming.pick_sunday_second_closetime));
                }

                @Override
                public void onDialogDismiss(String filter, String from, String to) {

                }
            });
        });

    }

    private void switchListeners() {
        swMondayM.setOnCheckedChangeListener(mondayCheckListener);
        swTuesdayM.setOnCheckedChangeListener(tuesdayCheckListener);
        swWednesdayM.setOnCheckedChangeListener(wednesdayCheckListener);
        swThursdayM.setOnCheckedChangeListener(thursdayCheckListener);
        swFridayM.setOnCheckedChangeListener(fridayCheckListener);
        swSaturdayM.setOnCheckedChangeListener(saturdayCheckListener);
        swSundayM.setOnCheckedChangeListener(sundayCheckListener);

        swMondayE.setOnCheckedChangeListener(mondayCheckListener);
        swTuesdayE.setOnCheckedChangeListener(tuesdayCheckListener);
        swWednesdayE.setOnCheckedChangeListener(wednesdayCheckListener);
        swThursdayE.setOnCheckedChangeListener(thursdayCheckListener);
        swFridayE.setOnCheckedChangeListener(fridayCheckListener);
        swSaturdayE.setOnCheckedChangeListener(saturdayCheckListener);
        swSundayE.setOnCheckedChangeListener(sundayCheckListener);
    }

    CompoundButton.OnCheckedChangeListener mondayCheckListener = (compoundButton, b) -> {
        if (b) {
            swMondayM.setText("Open");
            swMondayE.setText("Open");
            pickupTiming.pick_monday_status = "";
        } else {
            swMondayM.setText("Closed");
            swMondayE.setText("Closed");
            pickupTiming.pick_monday_status = "Close";
        }
        rangeMondayM.setEnabled(b);
        rangeMondayE.setEnabled(b);
        tvEditMondayM.setEnabled(b);
        tvEditMondayE.setEnabled(b);
    };

    CompoundButton.OnCheckedChangeListener tuesdayCheckListener = (compoundButton, b) -> {
        if (b) {
            swTuesdayM.setText("Open");
            swTuesdayE.setText("Open");
            pickupTiming.pick_tuesday_status = "";
        } else {
            swTuesdayM.setText("Closed");
            swTuesdayE.setText("Closed");
            pickupTiming.pick_tuesday_status = "Close";
        }
        rangeTuesdayM.setEnabled(b);
        rangeTuesdayE.setEnabled(b);
        tvEditTuesdayM.setEnabled(b);
        tvEditTuesdayE.setEnabled(b);
    };
    CompoundButton.OnCheckedChangeListener wednesdayCheckListener = (compoundButton, b) -> {
        if (b) {
            swWednesdayM.setText("Open");
            swWednesdayE.setText("Open");
            pickupTiming.pick_wednesday_status = "";
        } else {
            swWednesdayM.setText("Closed");
            swWednesdayE.setText("Closed");
            pickupTiming.pick_wednesday_status = "Close";
        }
        rangeWednesdayM.setEnabled(b);
        rangeWednesdayE.setEnabled(b);
        tvEditWednesdayM.setEnabled(b);
        tvEditWednesdayE.setEnabled(b);
    };
    CompoundButton.OnCheckedChangeListener thursdayCheckListener = (compoundButton, b) -> {
        if (b) {
            swThursdayM.setText("Open");
            swThursdayE.setText("Open");
            pickupTiming.pick_thursday_status = "";
        } else {
            swThursdayM.setText("Closed");
            swThursdayE.setText("Closed");
            pickupTiming.pick_thursday_status = "Close";
        }
        rangeThursdayM.setEnabled(b);
        rangeThursdayE.setEnabled(b);
        tvEditThursdayM.setEnabled(b);
        tvEditThursdayE.setEnabled(b);
    };
    CompoundButton.OnCheckedChangeListener fridayCheckListener = (compoundButton, b) -> {
        if (b) {
            swFridayM.setText("Open");
            swFridayE.setText("Open");
            pickupTiming.pick_friday_status = "";
        } else {
            swFridayM.setText("Closed");
            swFridayE.setText("Closed");
            pickupTiming.pick_friday_status = "Close";
        }
        rangeFridayM.setEnabled(b);
        rangeFridayE.setEnabled(b);
        tvEditFridayM.setEnabled(b);
        tvEditFridayE.setEnabled(b);
    };
    CompoundButton.OnCheckedChangeListener saturdayCheckListener = (compoundButton, b) -> {
        if (b) {
            swSaturdayM.setText("Open");
            swSaturdayE.setText("Open");
            pickupTiming.pick_saturday_status = "";
        } else {
            swSaturdayM.setText("Closed");
            swSaturdayE.setText("Closed");
            pickupTiming.pick_saturday_status = "Close";
        }
        rangeSaturdayM.setEnabled(b);
        rangeSaturdayE.setEnabled(b);
        tvEditSaturdayM.setEnabled(b);
        tvEditSaturdayE.setEnabled(b);
    };
    CompoundButton.OnCheckedChangeListener sundayCheckListener = (compoundButton, b) -> {
        if (b) {
            swSundayM.setText("Open");
            swSundayE.setText("Open");
            pickupTiming.pick_sunday_status = "";
        } else {
            swSundayM.setText("Closed");
            swSundayE.setText("Closed");
            pickupTiming.pick_sunday_status = "Close";
        }
        rangeSundayM.setEnabled(b);
        rangeSundayE.setEnabled(b);
        tvEditSaturdayM.setEnabled(b);
        tvEditSaturdayE.setEnabled(b);
    };

    private void saveDetails() throws JSONException {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                progressDialog.show();
            });
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject jObject = new JSONObject(new Gson().toJson(pickupTiming));
        Iterator<?> keys = jObject.keys();

        while (keys.hasNext()) {
            String key = (String) keys.next();
            String value = jObject.getString(key);
            if (!key.equalsIgnoreCase("id") || !key.equalsIgnoreCase("created_date") || !key.equalsIgnoreCase("restaurant_id") || !key.equalsIgnoreCase("pick_working_time"))
                map.put(key, value);

        }
        HashMap<String, HashMap<String, String>> mapJson = new HashMap<>();
        mapJson.put("restaurant_timing", map);
        AndroidNetworking.post(ApiEndPoints.restaurants + loggedInRestaurant.id)
                .addApplicationJsonBody(mapJson)
                .build()
                .getAsObject(RestaurantUser.class, new ParsedRequestListener<RestaurantUser>() {
                    @Override
                    public void onResponse(RestaurantUser response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                        }
                        try {
                            fetchProfile();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                            });
                        }
                    }
                });
    }

    private void fetchProfile() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> progressDialog.show());
        }
        AndroidNetworking.get(ApiEndPoints.restaurants + loggedInRestaurant.id)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        try {
                            myApp.getMyPreferences().saveLoggedInRestaurant(new Gson().fromJson(response.toString(), RestaurantUser.class));
                            myApp.getMyPreferences().saveSiteSettings(myApp.getMyPreferences().getLoggedInRestaurant().site_setting);
                            loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
                            pickupTiming = loggedInRestaurant.restaurant_timing;
                            updateViews();
                            updateTextViews();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                    }
                });
    }

    private String convertToHHMM(float value) {
        int hour = (int) (value / 60);
        int minute = (int) (value % 60);
        return CommonFunctions.formatUnknownDateTime(String.format("%02d:%02d", hour, minute), "HH:mm", "hh:mm a"); // output : "02:00"
    }

    private int convertToMinutes(String time) {
        String time24 = CommonFunctions.formatUnknownDateTime(time, "hh:mm a", "HH:mm");
        String[] units = time24.split(":"); //will break the string up into an array
        int hours = Integer.parseInt(units[0]); //first element
        int minutes = Integer.parseInt(units[1]); //second element
        int totalMin = (60 * hours) + minutes; //add up our values
        return totalMin;
    }
}
