package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class SettingsContactTiffintomDialog extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private MaterialButton btnEmail, btnCall;
    private DialogDismissListener dialogDismissListener;
    private ImageView ivClose;

    public static SettingsContactTiffintomDialog getInstance() {
        return new SettingsContactTiffintomDialog();
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_contact_tiffintom, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        btnEmail = view.findViewById(R.id.btnEmail);
        btnCall = view.findViewById(R.id.btnCall);
        ivClose = view.findViewById(R.id.ivClose);

    }

    private void setListeners() {
        ivClose.setOnClickListener(view -> {
            dismiss();
        });
        btnEmail.setOnClickListener(view -> {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss("email");
            dismiss();
        });
        btnCall.setOnClickListener(view -> {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss("call");
            dismiss();
        });
    }


}
