package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.gson.Gson;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.DeliveryFeesAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.DeliveryFee;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by Amrish on 14-12-2020.
 */
public class SettingsDeliveryFeesFragment extends BaseFragment {
    public static SettingsDeliveryFeesFragment getInstance() {
        return new SettingsDeliveryFeesFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    private RecyclerView rvDeliveryFees;
    private DeliveryFeesAdapter deliveryFeesAdapter;
    private ArrayList<DeliveryFee> deliveryFees = new ArrayList<>();
    private MaterialCardView cvAdd;
    private MaterialButton btnUpdate;
    private MaterialCardView cvFreeDel;
    private SwitchCompat switchFreeDel;
    private LinearLayout llFreeDel, llMainLayout;
    private TextView tvFreeDelMiles;
    DeliveryFee freeDelivery;
    private ImageView ivBack;

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        tvFreeDelMiles = view.findViewById(R.id.tvFreeDelMiles);
        llFreeDel = view.findViewById(R.id.llFreeDelivery);
        switchFreeDel = view.findViewById(R.id.switchFreeDel);
        cvFreeDel = view.findViewById(R.id.cvFreeDel);
        rvDeliveryFees = view.findViewById(R.id.rvDeliveryFees);
        cvAdd = view.findViewById(R.id.cvAdd);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        ivBack = view.findViewById(R.id.ivBack);

        deliveryFeesAdapter = new DeliveryFeesAdapter(deliveryFees, (position, data) -> {
            DeliveryFee deliveryFee = (DeliveryFee) data;
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(deliveryFee.delivery_miles, "Enter delivery miles");
            enterAmountDialogFragment.show(getChildFragmentManager(), "enter_miles");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    deliveryFee.delivery_miles = (String) o;
                    deliveryFees.set(position, deliveryFee);
                    deliveryFeesAdapter.notifyDataSetChanged();
                }
            });
        }, (position, data) -> {
            DeliveryFee deliveryFee = (DeliveryFee) data;
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(deliveryFee.delivery_charge, "Enter delivery fee");
            enterAmountDialogFragment.show(getChildFragmentManager(), "enter_amount");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    deliveryFee.delivery_charge = (String) o;
                    deliveryFees.set(position, deliveryFee);
                    deliveryFeesAdapter.notifyDataSetChanged();
                }
            });
        });
        rvDeliveryFees.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvDeliveryFees.setAdapter(deliveryFeesAdapter);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_delivery_fees, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        fetchProfile();
        setListeners();
    }

    private void updateViews() {
        deliveryFees.clear();
        if (loggedInRestaurant.delivery_setting != null && loggedInRestaurant.delivery_setting.size() > 0 && loggedInRestaurant.delivery_setting.get(0).getDelivery_charge() == 0) {
            freeDelivery = loggedInRestaurant.delivery_setting.get(0);
            loggedInRestaurant.delivery_setting.remove(0);
            switchFreeDel.setOnCheckedChangeListener(null);
            switchFreeDel.setChecked(true);
            freeDeliverySwitchListener();
            tvFreeDelMiles.setText(freeDelivery.delivery_miles + " miles");
        }
        if (loggedInRestaurant.delivery_setting != null)
            deliveryFees.addAll(loggedInRestaurant.delivery_setting);
        deliveryFeesAdapter.notifyDataSetChanged();
    }

    private void setListeners() {
        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
        cvAdd.setOnClickListener(view -> {
            DeliveryFee deliveryFee = new DeliveryFee();
            deliveryFee.delivery_charge = "0";
            deliveryFee.delivery_miles = "0";
            deliveryFees.add(deliveryFee);
            deliveryFeesAdapter.notifyDataSetChanged();
        });
        btnUpdate.setOnClickListener(view -> {
            boolean isValid = true;
            for (DeliveryFee deliveryFee : deliveryFees) {
                if (Float.parseFloat(deliveryFee.delivery_charge) == 0 || Float.parseFloat(deliveryFee.delivery_miles) == 0) {
                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Invalid delivery fees details");
                    isValid = false;
                    break;
                }
            }
            if (isValid) {
                updateDeliveryFees();
            }
        });
        freeDeliverySwitchListener();
        cvFreeDel.setOnClickListener(view -> {
            if (!switchFreeDel.isChecked()) {
                switchFreeDel.setChecked(true);
            } else {
                EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(!Validators.isNullOrEmpty(freeDelivery.delivery_miles) ? freeDelivery.delivery_miles : "0", "Enter delivery miles");
                enterAmountDialogFragment.show(getChildFragmentManager(), "enter_miles");
                enterAmountDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        freeDelivery.delivery_miles = (String) o;
                        tvFreeDelMiles.setText(freeDelivery.delivery_miles + " miles");
                    } else {
                        if (Validators.isNullOrEmpty(freeDelivery.delivery_miles)) {
                            freeDelivery = null;
                            switchFreeDel.setChecked(false);
                        }
                    }
                });
            }
        });
    }

    private void freeDeliverySwitchListener() {
        switchFreeDel.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) {
                if (freeDelivery == null)
                    freeDelivery = new DeliveryFee();
                EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(!Validators.isNullOrEmpty(freeDelivery.delivery_miles) ? freeDelivery.delivery_miles : "0", "Enter delivery miles");
                enterAmountDialogFragment.show(getChildFragmentManager(), "enter_miles");
                enterAmountDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        freeDelivery.delivery_miles = (String) o;
                        tvFreeDelMiles.setText(freeDelivery.delivery_miles + " miles");
                    } else {
                        if (Validators.isNullOrEmpty(freeDelivery.delivery_miles)) {
                            freeDelivery = null;
                            switchFreeDel.setChecked(false);
                        }
                    }
                });
            } else {
                freeDelivery = null;
            }
        });
    }

    private void updateDeliveryFees() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            if (freeDelivery != null) {
                freeDelivery.delivery_charge = "0";
                deliveryFees.add(0, freeDelivery);
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("delivery_setting", new Gson().toJson(deliveryFees));
            AndroidNetworking.post(ApiEndPoints.restaurants+loggedInRestaurant.id)
                    .addApplicationJsonBody(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                fetchProfile();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchProfile() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> progressDialog.show());
        }
        AndroidNetworking.get(ApiEndPoints.restaurants + loggedInRestaurant.id)
                // .addBodyParameter("action", "StoreDetailAll")
                // .addBodyParameter("user_id", resId)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        try {
                            myApp.getMyPreferences().saveLoggedInRestaurant(new Gson().fromJson(response.toString(), RestaurantUser.class));
                            myApp.getMyPreferences().saveSiteSettings(myApp.getMyPreferences().getLoggedInRestaurant().site_setting);
                            loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
                            updateViews();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                    }
                });
    }
}
