package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.RestaurantPaymentMethod;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.util.HashMap;

public class SettingsDineinOptionsFragment extends BaseFragment {

    private SwitchCompat switchOrders, switchTips, switchCod;
    private MaterialButton btnUpdate;
    private LinearLayout llMainLayout;
    private ImageView ivBack;

    public static SettingsDineinOptionsFragment getInstance() {
        return new SettingsDineinOptionsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dinein_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListeners();
    }

    private void updateViews() {
        try {
            switchTips.setChecked(loggedInRestaurant.gratuity.equalsIgnoreCase("1"));
            switchOrders.setChecked(loggedInRestaurant.dine_in.equalsIgnoreCase("1"));
            boolean isCodOn = false;
            for (RestaurantPaymentMethod paymentMethod : loggedInRestaurant.payment_methods) {
                if (paymentMethod.payment_method_name.equalsIgnoreCase("cod")) {
                    if (paymentMethod.dinein_android_status.equalsIgnoreCase("y")) isCodOn = true;
                }
            }
            switchCod.setChecked(isCodOn);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            switchOrders.setOnCheckedChangeListener((compoundButton, b) -> {
                if (b) {
                    loggedInRestaurant.dine_in = "1";
                } else loggedInRestaurant.dine_in = "0";
            });
            switchTips.setOnCheckedChangeListener((compoundButton, b) -> {
                if (b) {
                    loggedInRestaurant.gratuity = "1";
                } else loggedInRestaurant.gratuity = "0";
            });
            btnUpdate.setOnClickListener(view -> {
                HashMap<String, String> params = new HashMap<>();
                params.put("gratuity", loggedInRestaurant.gratuity);
                params.put("dine_in", loggedInRestaurant.dine_in);
                updateDetails(params);
            });
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        switchCod = view.findViewById(R.id.switchCod);
        switchOrders = view.findViewById(R.id.switchOrders);
        switchTips = view.findViewById(R.id.switchTips);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        ivBack = view.findViewById(R.id.ivBack);
    }

    private void updateDetails(HashMap<String, String> params) {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> progressDialog.show());
        }
        AndroidNetworking.post(ApiEndPoints.restaurants + loggedInRestaurant.id)
                .addApplicationJsonBody(params)
                .build()
                .getAsObject(RestaurantUser.class, new ParsedRequestListener<RestaurantUser>() {
                    @Override
                    public void onResponse(RestaurantUser response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        try {
                            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Details updated");
                            myApp.getMyPreferences().saveLoggedInRestaurant(loggedInRestaurant);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        anError.printStackTrace();
                        CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                    }
                });
    }
}
