package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.network.ApiEndPoints;

import org.json.JSONObject;

import java.util.HashMap;

public class SettingsFeedbackFragment extends BaseFragment {


    private EditText etSubject, etDescription;
    private TextView tvSubject, tvWordCounter;
    private MaterialButton btnSend;
    private LinearLayout llSubject, llMainLayout;
    private String subjectData;
    private ImageView ivBack;
    private RestaurantUser loggedInUser = myApp.getMyPreferences().getLoggedInRestaurant();

    public static SettingsFeedbackFragment getInstance() {
        return new SettingsFeedbackFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        btnSend = view.findViewById(R.id.btnSend);
        etDescription = view.findViewById(R.id.etFeedbackProblem);
        etSubject = view.findViewById(R.id.etFeedbackSubject);
        tvSubject = view.findViewById(R.id.tvFeedbackSubject);
        tvWordCounter = view.findViewById(R.id.tvWordCounter);
        llSubject = view.findViewById(R.id.llFeedbackSubject);
        ivBack = view.findViewById(R.id.ivBack);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_feedback, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {

        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
        tvSubject.setOnClickListener(v -> {
            CommonFunctions.hideKeyboard(getActivity(), etDescription);
            SettingsFeedbackSubjectBottomSheetFragment feedbackSubjectBottomSheetFragment = SettingsFeedbackSubjectBottomSheetFragment.getInstance(subjectData);
            feedbackSubjectBottomSheetFragment.show(getChildFragmentManager(), "feedback subject");
            feedbackSubjectBottomSheetFragment.setDialogDismissListener(o -> getSubject(o));
        });
        etDescription.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {

                int length = etDescription.length();
                tvWordCounter.setText(length + "/300");
                if (length > 300) {
                    tvWordCounter.setTextColor(getResources().getColor(R.color.red));
                } else {
                    tvWordCounter.setTextColor(getResources().getColor(R.color.black));
                }
            }
        });
        btnSend.setOnClickListener(v -> {
            if (isValid()) {
                new Thread(this::sendFeedback).start();
            }
        });
    }

    private boolean isValid() {
        etSubject.setError(null);
        etDescription.setError(null);
        if (Validators.isNullOrEmpty(tvSubject.getText().toString())) {
            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Please select feedback subject");
            return false;
        }
        if (!Validators.isNullOrEmpty(subjectData) && subjectData.equalsIgnoreCase("other") && Validators.isNullOrEmpty(etSubject.getText().toString())) {
            etSubject.setError("Please enter feedback subject");
            etSubject.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etDescription.getText().toString())) {
            etDescription.setError("Please enter your feedback");
            etDescription.requestFocus();
            return false;
        }
        if (etDescription.getText().toString().length() > 300) {
            etDescription.setError("Character should be less then 300.");
            return false;
        }
        return true;
    }

    private void sendFeedback() {
        try {
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressDialog.show());

            HashMap<String, String> params = new HashMap<>();
            params.put("customer_id",String.valueOf(loggedInUser.user_id));
            params.put("subject",etSubject.getText().toString());
            params.put("message",etDescription.getText().toString());
            AndroidNetworking.post(ApiEndPoints.app_feedback)
                    .addQueryParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null)
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                            try {
                               // String message = response.getString("message");
                               // if (response.getString("success").equalsIgnoreCase("1")) {
                                    CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Feedback sent successfully.");
                                    etSubject.setText("");
                                    tvSubject.setText("");
                                    etDescription.setText("");
                              //  } else {
                              //      CommonFunctions.showSnackBar(getActivity(), llMainLayout, message);
                              //  }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null)
                                    progressDialog.dismiss();
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Something went wrong");
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void getSubject(Object o) {
        subjectData = (String) o;
        if (subjectData.equalsIgnoreCase("other")) {
            tvSubject.setText(subjectData);
            llSubject.setVisibility(View.VISIBLE);
            etSubject.setText("");
            etSubject.requestFocus();
        } else {
            llSubject.setVisibility(View.GONE);
            etSubject.setText(subjectData);
            tvSubject.setText(subjectData);
        }
    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etDescription);
        super.onStop();
    }
}
