package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.utils.ToastUtils;

public class SettingsFeedbackSubjectBottomSheetFragment extends BaseBottomSheet {
    private RadioButton rbCrashed, rbNotWorking, rbDataInaccurate, rbSlow, rbPayment, rbSuggestions, rbOther;
    private MaterialButton btnConfirm;
    private DialogDismissListener dialogDismissListener;
    private String subject;
    private String selectedSubject;

    public static SettingsFeedbackSubjectBottomSheetFragment getInstance(String subjectData) {
        SettingsFeedbackSubjectBottomSheetFragment feedbackSubjectBottomSheetFragment = new SettingsFeedbackSubjectBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("selected_subject", subjectData);
        feedbackSubjectBottomSheetFragment.setArguments(bundle);
        return feedbackSubjectBottomSheetFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_feedback_subject, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            selectedSubject = getArguments().getString("selected_subject");
        }
    }

    private void updateViews() {
        if (selectedSubject != null) {
            if (selectedSubject.equalsIgnoreCase(rbCrashed.getText().toString()))
                rbCrashed.setChecked(true);
            else if (selectedSubject.equalsIgnoreCase(rbNotWorking.getText().toString()))
                rbNotWorking.setChecked(true);
            else if (selectedSubject.equalsIgnoreCase(rbDataInaccurate.getText().toString()))
                rbDataInaccurate.setChecked(true);
            else if (selectedSubject.equalsIgnoreCase(rbSlow.getText().toString()))
                rbSlow.setChecked(true);
            else if (selectedSubject.equalsIgnoreCase(rbPayment.getText().toString()))
                rbPayment.setChecked(true);
            else if (selectedSubject.equalsIgnoreCase(rbSuggestions.getText().toString()))
                rbSuggestions.setChecked(true);
            else
                rbOther.setChecked(true);
        }
    }

    private void setListners() {
        super.setListeners();
        btnConfirm.setOnClickListener(view -> {
            if (rbCrashed.isChecked() || rbNotWorking.isChecked() || rbDataInaccurate.isChecked() || rbSlow.isChecked() || rbPayment.isChecked() || rbSuggestions.isChecked() || rbOther.isChecked()) {
                if (rbCrashed.isChecked()) {
                    subject = rbCrashed.getText().toString();
                } else if (rbNotWorking.isChecked()) {
                    subject = rbNotWorking.getText().toString();
                } else if (rbDataInaccurate.isChecked()) {
                    subject = rbDataInaccurate.getText().toString();
                } else if (rbSlow.isChecked()) {
                    subject = rbSlow.getText().toString();
                } else if (rbPayment.isChecked()) {
                    subject = rbPayment.getText().toString();
                } else if (rbSuggestions.isChecked()) {
                    subject = rbSuggestions.getText().toString();
                } else {
                    subject = rbOther.getText().toString();
                }

                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(subject);
                dismiss();
            } else {
                ToastUtils.makeToast(getActivity(), "Please Select one option");
            }
        });
    }


    @Override
    protected void initViews(View view) {
        super.initViews(view);
        ivClose = view.findViewById(R.id.ivClose);
        rbCrashed = view.findViewById(R.id.rb1);
        rbNotWorking = view.findViewById(R.id.rb2);
        rbDataInaccurate = view.findViewById(R.id.rb3);
        rbSlow = view.findViewById(R.id.rb4);
        rbPayment = view.findViewById(R.id.rb5);
        rbSuggestions = view.findViewById(R.id.rb6);
        rbOther = view.findViewById(R.id.rbOther);
        btnConfirm = view.findViewById(R.id.btnSend);
    }
}
