package com.tiffintom.partner1.fragments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentTransaction;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SiteSettings;
import com.tiffintom.partner1.network.ApiEndPoints;

import org.json.JSONObject;

public class SettingsFragment extends BaseFragment {

    private LinearLayout llDetails, llContact, llFeedback, llBankDetails, llProfile, llLogout, llMainLayout;
    private LinearLayout llManagement;
    private SiteSettings siteSettings = myApp.getMyPreferences().getSiteSettings();

    public static SettingsFragment getInstance() {
        return new SettingsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {
        llDetails.setOnClickListener(v -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsRestaurantDetailsFragment.getInstance(), "Details");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llManagement.setOnClickListener(v -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsRestaurantManagementFragment.getInstance(), "Restaurant Management");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llFeedback.setOnClickListener(v -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsFeedbackFragment.getInstance(), "Feedback");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llContact.setOnClickListener(view -> {
            SettingsContactTiffintomDialog settingsContactTiffintomDialog = SettingsContactTiffintomDialog.getInstance();
            settingsContactTiffintomDialog.show(getChildFragmentManager(), "contact_us");
            settingsContactTiffintomDialog.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("call")) {
                        // Do Call

                        Intent intent = new Intent();
                        intent.setAction(Intent.ACTION_DIAL);
                        intent.setData(Uri.parse("tel: " + MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().restaurant_phone));
                        startActivity(intent);
                    } else {
                        //Do Email
                        Intent intent = new Intent(Intent.ACTION_SENDTO);
                        intent.setData(Uri.parse("mailto:")); // only email apps should handle this
                        intent.putExtra(Intent.EXTRA_EMAIL, new String[]{siteSettings.contact_us_email});
                        startActivity(intent);

                    }
                }
            });
        });
        llBankDetails.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsBankDetailsFragment.getInstance(), "Bank Details");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llProfile.setOnClickListener(v -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsProfileFragment.getInstance(), "Profile");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llLogout.setOnClickListener(view -> {
            askForLogout();
        });
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        llDetails = view.findViewById(R.id.ll_Details);
        llContact = view.findViewById(R.id.llContact);
        llManagement = view.findViewById(R.id.llManagement);
        llFeedback = view.findViewById(R.id.llFeedback);
        llBankDetails = view.findViewById(R.id.llBankDetails);
        llProfile = view.findViewById(R.id.llProfile);
        llLogout = view.findViewById(R.id.llLogout);

    }

    private void fetchProfile() {
        if(loggedInRestaurant!=null){
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            AndroidNetworking.get(ApiEndPoints.restaurants + loggedInRestaurant.id)
                    // .addBodyParameter("action", "StoreDetailAll")
                    // .addBodyParameter("user_id", resId)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                myApp.getMyPreferences().saveLoggedInRestaurant(new Gson().fromJson(response.toString(), RestaurantUser.class));
                                myApp.getMyPreferences().saveSiteSettings(myApp.getMyPreferences().getLoggedInRestaurant().site_setting);
                                loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                        }
                    });
        }
    }

    private void askForLogout() {
        AlertDialog alertDialog = new AlertDialog.Builder(getActivity()).create();
        alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View dialogView = inflater.inflate(R.layout.dialog_logout, null);
        TextView tvCancle = dialogView.findViewById(R.id.tvCancel);
        TextView tvConfirm = dialogView.findViewById(R.id.tvConfirm);

        tvConfirm.setOnClickListener(view -> {
            alertDialog.dismiss();
            myApp.stopOrderSound();
            myApp.stopDelayedOrderSound();
            myApp.stopNewMessageSound();
            myApp.logoutMerchant(getActivity(), false);
            myApp.logout(getActivity());
        });
        tvCancle.setOnClickListener(view -> {
            alertDialog.dismiss();
        });

        alertDialog.setView(dialogView);
        alertDialog.setCancelable(false);
        alertDialog.show();
    }

    @Override
    public void onResume() {
        super.onResume();
        fetchProfile();
    }
}
