package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;

public class SettingsOffersFragment extends BaseFragment {

    private LinearLayout llDiscountCodes, llAutoDiscount;
    private ImageView ivBack;

    public static SettingsOffersFragment getInstance() {
        return new SettingsOffersFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_restaurant_offers, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {
        llAutoDiscount.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsAutoDiscountFragment.getInstance(), "Offers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llDiscountCodes.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsVoucherCodesFragment.getInstance(), "Vouchers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llDiscountCodes = view.findViewById(R.id.llDiscountCode);
        llAutoDiscount = view.findViewById(R.id.llAutoDiscount);
        ivBack = view.findViewById(R.id.ivBack);
    }
}
