package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;

/**
 * Created by Amrish on 24-12-2020.
 */
public class SettingsOpeningHoursFragment extends BaseFragment {
    private ImageView ivBack;
    public static SettingsOpeningHoursFragment getInstance() {
        return new SettingsOpeningHoursFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_openinghours, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {
        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        LinearLayout llDeliveryHours = view.findViewById(R.id.llDeliveryHours);
        LinearLayout llCollectionHours = view.findViewById(R.id.llCollectionHours);
        ivBack = view.findViewById(R.id.ivBack);
        if (loggedInRestaurant.restaurant_delivery.equalsIgnoreCase("yes")) {
            llDeliveryHours.setVisibility(View.VISIBLE);
        } else {
            llDeliveryHours.setVisibility(View.GONE);
        }
        if (loggedInRestaurant.restaurant_pickup.equalsIgnoreCase("yes")) {
            llCollectionHours.setVisibility(View.VISIBLE);
        } else {
            llCollectionHours.setVisibility(View.GONE);
        }

        llCollectionHours.setOnClickListener(view1 -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsCollectionHoursFragment.getInstance(), "CollectionHours");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llDeliveryHours.setOnClickListener(view1 -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsDeliveryHoursFragment.getInstance(), "DeliveryHours");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
    }
}
