package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.fragment.app.FragmentTransaction;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

public class SettingsOrderOptionsFragment extends BaseFragment {

    private LinearLayout llDeliveryFee, llOrderRequirements;
    private ImageView ivBack;
    private SwitchCompat switchCompat;

    public static SettingsOrderOptionsFragment getInstance() {
        return new SettingsOrderOptionsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_order_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateOrderTakingStatus();
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llDeliveryFee = view.findViewById(R.id.llDeliveryFee);
        llOrderRequirements = view.findViewById(R.id.llOrderRequirements);
        ivBack = view.findViewById(R.id.ivBack);
        switchCompat = view.findViewById(R.id.switchOrders);
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
        llOrderRequirements.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsOrderRequirementFragment.getInstance(), "Order requirements");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llDeliveryFee.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsDeliveryFeesFragment.getInstance(), "Order requirements");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        switchCompat.setOnCheckedChangeListener(checkedChangeListener);
    }


    CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
            EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("online_order", b ? "Yes" : "No");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "enter_password");
            enterPasswordDialogFragment.setCancelable(false);
            enterPasswordDialogFragment.setDialogDismissListener(changeOrderAcceptingStatusDialogListener);
        }
    };

    DialogDismissListener changeOrderAcceptingStatusDialogListener = new DialogDismissListener() {
        @Override
        public void onDialogDismiss(Object o) {
            switchCompat.setOnCheckedChangeListener(null);
            updateOrderTakingStatus();
            switchCompat.setOnCheckedChangeListener(checkedChangeListener);
        }
    };

    private void updateOrderTakingStatus() {
        switchCompat.setChecked(myApp.getMyPreferences().getLoggedInRestaurant().online_order.equalsIgnoreCase("Yes"));
    }

}
