package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.card.MaterialCardView;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.network.ApiEndPoints;

import org.json.JSONObject;

import java.util.HashMap;

public class SettingsOrderRequirementFragment extends BaseFragment {

    private MaterialCardView cvOrderValue;
    private TextView tvOrderValue;
    private ImageView ivBack;
    private LinearLayout llMainLayout;

    public static SettingsOrderRequirementFragment getInstance() {
        return new SettingsOrderRequirementFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_order_requirements, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        tvOrderValue.setText(myApp.getCurrencySymbol() + (loggedInRestaurant.minimum_order));
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        cvOrderValue = view.findViewById(R.id.cvOrderValue);
        tvOrderValue = view.findViewById(R.id.tvOrderValue);
        ivBack = view.findViewById(R.id.ivBack);
    }

    private void setListeners() {

        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
        cvOrderValue.setOnClickListener(view -> {
            EnterAmountDialogFragment enterAmountDialogFragment = EnterAmountDialogFragment.getInstance(loggedInRestaurant.minimum_order);
            enterAmountDialogFragment.show(getChildFragmentManager(), "Enter amount");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    loggedInRestaurant.minimum_order = String.valueOf(o);
                    tvOrderValue.setText(myApp.getCurrencySymbol() + (loggedInRestaurant.minimum_order));
                    HashMap<String, String> params = new HashMap<>();
                    params.put("minimum_order",loggedInRestaurant.minimum_order);
                    updateDetails(params);
                }
            });
        });
    }

    private void updateDetails(HashMap<String, String> params) {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> progressDialog.show());
        }
        AndroidNetworking.post(ApiEndPoints.restaurants + loggedInRestaurant.id)
                .addApplicationJsonBody(params)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        try {
                            CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Details updated");
                            myApp.getMyPreferences().saveLoggedInRestaurant(loggedInRestaurant);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        anError.printStackTrace();
                        CommonFunctions.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                    }
                });
    }
}
