package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.models.RestaurantUser;

public class SettingsProfileFragment extends BaseFragment {


    private ImageView ivBack;

    public static SettingsProfileFragment getInstance() {
        return new SettingsProfileFragment();
    }

    private RestaurantUser loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
    private TextView tvContactName, tvPhone, tvEmail;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_profile, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        tvContactName = view.findViewById(R.id.tvContactName);
        tvEmail = view.findViewById(R.id.tvContactEmail);
        tvPhone = view.findViewById(R.id.tvContactNumber);
        ivBack = view.findViewById(R.id.ivBack);
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    private void updateViews() {
        loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
        tvContactName.setText(loggedInRestaurant.contact_name);
        tvPhone.setText(loggedInRestaurant.restaurant_phone);
        tvEmail.setText(loggedInRestaurant.contact_email);

    }
}
