package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.interfaces.DialogDismissListener;

public class SettingsReservationOptionsFragment extends BaseFragment {

    private ImageView ivBack;
    private SwitchCompat switchCompat;

    public static SettingsReservationOptionsFragment getInstance() {
        return new SettingsReservationOptionsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_reservation_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateReservationStatus();
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        ivBack = view.findViewById(R.id.ivBack);
        switchCompat = view.findViewById(R.id.switchReservations);
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());

        switchCompat.setOnCheckedChangeListener(checkedChangeListener);
    }

    CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
            EnterPasswordDialogFragment enterPasswordDialogFragment = EnterPasswordDialogFragment.getInstance("booking_status", b ? "Yes" : "No");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "enter_password");
            enterPasswordDialogFragment.setCancelable(false);
            enterPasswordDialogFragment.setDialogDismissListener(changeOrderAcceptingStatusDialogListener);
        }
    };
    DialogDismissListener changeOrderAcceptingStatusDialogListener = new DialogDismissListener() {
        @Override
        public void onDialogDismiss(Object o) {
            switchCompat.setOnCheckedChangeListener(null);
            updateReservationStatus();
            switchCompat.setOnCheckedChangeListener(checkedChangeListener);
        }
    };

    private void updateReservationStatus() {
        switchCompat.setChecked(myApp.getMyPreferences().getLoggedInRestaurant().booking_status.equalsIgnoreCase("Yes"));
    }
}
