package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.models.RestaurantUser;

public class SettingsRestaurantDetailsFragment extends BaseFragment {

    private TextView tvDescription;
    private ImageView ivEdit;
    private ImageView ivBack;
    public static SettingsRestaurantDetailsFragment getInstance() {
        return new SettingsRestaurantDetailsFragment();
    }

    private RestaurantUser loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
    private TextView tvCompanyName, tvRestaurantName, tvPhone, tvEmail;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_restaurant_details, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        ivEdit = view.findViewById(R.id.ivEdit);
        tvDescription = view.findViewById(R.id.tvDecription);
        tvCompanyName = view.findViewById(R.id.tvCompanyName);
        tvEmail = view.findViewById(R.id.tvRestaurantEmail);
        tvPhone = view.findViewById(R.id.tvRestaurantPhone);
        tvRestaurantName = view.findViewById(R.id.tvRestaurantName);
        ivBack = view.findViewById(R.id.ivBack);
    }

    private void setListeners() {
        ivEdit.setOnClickListener(v -> {
            EditRestaurantDescriptionBottomsheet descriptionBottomsheet = EditRestaurantDescriptionBottomsheet.getInstance(tvDescription.getText().toString());
            descriptionBottomsheet.show(getChildFragmentManager(), "edit_description");
            descriptionBottomsheet.setDialogDismissListener(o -> updateViews());
        });
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    private void updateViews() {
        loggedInRestaurant = myApp.getMyPreferences().getLoggedInRestaurant();
        tvRestaurantName.setText(loggedInRestaurant.restaurant_name);
        tvPhone.setText(loggedInRestaurant.restaurant_phone);
        tvEmail.setText(loggedInRestaurant.username);
        tvDescription.setText(loggedInRestaurant.restaurant_about);
    }
}
