package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseFragment;

public class SettingsRestaurantManagementFragment extends BaseFragment {

    private LinearLayout llOpeningHours, llOrderOptions, llPreOrderOptions, llDineinOptions, llOffers, llReservationOptions;
    private ImageView ivBack;

    public static SettingsRestaurantManagementFragment getInstance() {
        return new SettingsRestaurantManagementFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_restaurant_management, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
    }

    private void setListeners() {
        llOrderOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsOrderOptionsFragment.getInstance(), "Order options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llDineinOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(R.id.nav_host_fragment, SettingsDineinOptionsFragment.getInstance(), "Dine in options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llPreOrderOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsPreorderOptionsFragment.getInstance(), "Pre-order options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llOffers.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsOffersFragment.getInstance(), "Offers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llOpeningHours.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsOpeningHoursFragment.getInstance(), "Offers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llReservationOptions.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), SettingsReservationOptionsFragment.getInstance(), "Reservation options");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llOpeningHours = view.findViewById(R.id.llOpeningHours);
        llOrderOptions = view.findViewById(R.id.llOrderOptions);
        llPreOrderOptions = view.findViewById(R.id.llPreOrderOptions);
        llDineinOptions = view.findViewById(R.id.llDineinOptions);
        llOffers = view.findViewById(R.id.llOffers);
        llReservationOptions = view.findViewById(R.id.llReservationOptions);
        ivBack = view.findViewById(R.id.ivBack);

        llPreOrderOptions.setVisibility(View.GONE);
        if (loggedInRestaurant.restaurant_delivery.equalsIgnoreCase("yes")) {
            llOrderOptions.setVisibility(View.VISIBLE);
        } else {
            llOrderOptions.setVisibility(View.GONE);
        }
    }
}
