package com.tiffintom.partner1.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.adapters.VouchersAdapter;
import com.tiffintom.partner1.base.BaseFragment;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.models.DeliveryFee;
import com.tiffintom.partner1.models.Voucher;
import com.tiffintom.partner1.network.ApiEndPoints;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Amrish on 14-12-2020.
 */
public class SettingsVoucherCodesFragment extends BaseFragment {
    public static SettingsVoucherCodesFragment getInstance() {
        return new SettingsVoucherCodesFragment();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    private RecyclerView rvVoucherCodes;
    private ArrayList<Voucher> vouchers = new ArrayList<>();
    private ArrayList<Voucher> removedVouchers = new ArrayList<>();
    private MaterialCardView cvAdd;
    private LinearLayout llMainLayout;
    private MaterialButton btnUpdate;
    DeliveryFee freeDelivery;
    private LinearLayout llLoading;
    private VouchersAdapter voucherAdapter;
    private Type voucherType = new TypeToken<List<Voucher>>() {
    }.getType();
    private ImageView ivBack;

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        llMainLayout = view.findViewById(R.id.llMainLayout);
        rvVoucherCodes = view.findViewById(R.id.rvVoucherCodes);
        cvAdd = view.findViewById(R.id.cvAdd);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        llLoading = view.findViewById(R.id.llLoading);
        ivBack = view.findViewById(R.id.ivBack);

        voucherAdapter = new VouchersAdapter(vouchers, (position, data) -> {
            Voucher voucher = (Voucher) data;
            VoucherCodeEditBottomFragment voucherCodeEditBottomFragment = VoucherCodeEditBottomFragment.getInstance(voucher);
            voucherCodeEditBottomFragment.show(getActivity().getSupportFragmentManager(), "voucher_code");
            voucherCodeEditBottomFragment.setDialogDismissListener(o -> {
                if (o != null) {
                    vouchers.set(position, (Voucher) o);
                    voucherAdapter.notifyDataSetChanged();
                    updateVoucherCodes();
                }
            });
        }, (position, data) -> {
            removedVouchers.add((Voucher) data);
            updateVoucherCodes();
        });
        rvVoucherCodes.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        rvVoucherCodes.setNestedScrollingEnabled(false);
        rvVoucherCodes.setAdapter(voucherAdapter);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_voucher_codes, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setListeners();
        fetchData();
    }

    private void setListeners() {
        cvAdd.setOnClickListener(view -> {
            VoucherCodeEditBottomFragment voucherCodeEditBottomFragment = VoucherCodeEditBottomFragment.getInstance(null);
            voucherCodeEditBottomFragment.show(getActivity().getSupportFragmentManager(), "voucher_code");
            voucherCodeEditBottomFragment.setDialogDismissListener(o -> {
                vouchers.add((Voucher) o);
                updateVoucherCodes();
            });
        });

        ivBack.setOnClickListener(v -> getActivity().onBackPressed());

    }

    private void fetchData() {
        new Thread(this::fetchVoucherCodes).start();
    }

    private void fetchVoucherCodes() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                });
            }
            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_id", myApp.getMyPreferences().getLoggedInRestaurant().id);
            params.put("nopaginate", "1");
            AndroidNetworking.get(ApiEndPoints.restaurants_vouchers)
                    .addQueryParameter(params)
                    .build()
                    .getAsObjectList(Voucher.class, new ParsedRequestListener<List<Voucher>>() {
                        @Override
                        public void onResponse(List<Voucher> response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                });
                            }
                            try {
                                vouchers.clear();
                                removedVouchers.clear();
                                vouchers.addAll(response);
                                voucherAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                });
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateVoucherCodes() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            ArrayList<Object> allVouchers = new ArrayList<>();
            allVouchers.addAll(vouchers);
            allVouchers.addAll(removedVouchers);

            HashMap<String, String> params = new HashMap<>();
            params.put("restaurant_vouchers",new Gson().toJson(allVouchers));

            AndroidNetworking.post(ApiEndPoints.restaurants_vouchers+"/bulk")
                    .addApplicationJsonBody(params)
                    .build()
                    .getAsObjectList(Voucher.class, new ParsedRequestListener<List<Voucher>>() {
                        @Override
                        public void onResponse(List<Voucher> response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                CommonFunctions.showSnackBar(getActivity(), llMainLayout,"Vouchers updated successfully.");
                                fetchData();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
