package com.tiffintom.partner1.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import androidx.core.widget.doAfterTextChanged
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.button.MaterialButton
import com.tiffintom.partner1.MyApp
import com.tiffintom.partner1.MyApp.df.format
import com.tiffintom.partner1.R
import com.tiffintom.partner1.activities.HomeActivity
import com.tiffintom.partner1.adapters.AmountSelectionAdapter
import com.tiffintom.partner1.base.BaseFragment
import com.tiffintom.partner1.interfaces.MoneyTextWatcher1
import com.tiffintom.partner1.models.AppIntroModel
import com.tiffintom.partner1.utils.Constants
import com.tiffintom.partner1.utils.ToastUtils

class Theme2PaymentSelection: BaseFragment() {
    var edtAmount: EditText? = null
    var rvAmountSelection: RecyclerView? = null
    var btnSubmit: MaterialButton? = null
    private lateinit var amountSelectionAdapter: AmountSelectionAdapter
    var totalAmount = ""
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.fragment_theme2_payment_selection, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        edtAmount = view.findViewById(R.id.edt_amount)
        edtAmount!!.addTextChangedListener( MoneyTextWatcher1(edtAmount))
        rvAmountSelection = view.findViewById(R.id.rv_amount_selection)
        btnSubmit = view.findViewById(R.id.btnSubmit)
        setAmountSelectionAdapter()
        edtAmount!!.doAfterTextChanged {
            totalAmount = format(
                edtAmount!!.text.toString()
                    .toFloat()
            )
            btnSubmit!!.text = "Charge ${MyApp.getInstance().currencySymbol}${totalAmount}"
        }
        btnSubmit!!.setOnClickListener {
            if(isEmpty()){
                ToastUtils.makeToast(requireContext(),"Amount should be greater than zero")
            }else{
                val totalAmount: Float = edtAmount!!.text.toString().replace(",", "").toFloat()
                if (totalAmount <= 0.30) {
                    ToastUtils.makeToast(requireContext(),"Amount should be greater than 0.30")
                }else{
                    changeFragment(PaymentTypeSelection())
                }
            }
        }
    }

    private fun changeFragment(fragment: Fragment) {
        val manager: FragmentManager = requireActivity().supportFragmentManager
        val transaction = manager.beginTransaction()
        val bundle = Bundle()
        bundle.putString(Constants.TOTAL_AMOUNT_FOR_ARGUMENT,totalAmount)
        fragment.arguments = bundle
        transaction.replace(R.id.nav_host_fragment, fragment,"payment_type_selection")
        transaction.addToBackStack("payment_type_selection")
        transaction.commit()
    }

    private fun isEmpty(): Boolean {
        return edtAmount!!.text.toString().equals(
            "",
            ignoreCase = true
        ) || edtAmount!!.text.toString().replace(",", "").toFloat() <= 0
    }

    private fun setAmountSelectionAdapter() {
        val amountSelectionList = arrayListOf<AppIntroModel>()
        repeat(9) {
            amountSelectionList.add(
                AppIntroModel(
                    number = it + 1
                )
            )
        }
        amountSelectionList.add(
            AppIntroModel(
                isDoubleZero = true
            )
        )
        amountSelectionList.add(
            AppIntroModel(
                number = 0
            )
        )
        amountSelectionList.add(
            AppIntroModel(
                isDelete = true
            )
        )
        amountSelectionAdapter =
            AmountSelectionAdapter(
                requireContext(),
                amountSelectionList,
                (requireActivity() as HomeActivity).heightOfTheScreen
            ) { obj, position ->
                try {
                    if (obj.isDoubleZero) {
                        edtAmount!!.setText("${edtAmount!!.text}00")
                    } else if (obj.isDelete) {
                        val cleanString: String =
                            edtAmount!!.text.toString()
                                .replace("[£,.]".toRegex(), "")
                        cleanString.replace("\\D".toRegex(), "")
                        edtAmount!!.setText(
                            if (cleanString == "") "" else cleanString.dropLast(
                                1
                            )
                        )
                    } else {
                        edtAmount!!.setText(
                            "${
                                edtAmount!!.text.toString().replace(",", "")
                            }${obj.number}"
                        )
                    }
                    repeat(amountSelectionAdapter.amountSelectionList.size) {
                        amountSelectionAdapter.amountSelectionList[it].isSelected = false
                    }
                    obj.isSelected = true
                    amountSelectionAdapter.notifyDataSetChanged()
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        rvAmountSelection!!.adapter = amountSelectionAdapter
    }
}