package com.tiffintom.partner1.fragments;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.TimePicker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.FilterDialogDismissListener;
import com.tiffintom.partner1.utils.ToastUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by Amrish on 04-02-2021.
 */
public class TimeRangePickerFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }


    public static TimeRangePickerFragment getInstance(String title, String from, String to) {
        TimeRangePickerFragment rejectReasonDialog = new TimeRangePickerFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("from", from);
        bundle.putString("to", to);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    private String title;
    private MaterialButton btnConfirm, btnCancel;
    private LinearLayout llToDate, llFromDate;
    private TextView tvInfo, tvTitle, tvFromDate, tvToDate;
    String fromDateString, toDateString;
    Date fromDate, toDate;
    Calendar fromCalendar, toCalendar;
    private Calendar today = Calendar.getInstance();
    private FilterDialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(FilterDialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_date_picker, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        title = getArguments().getString("title");
        fromDateString = getArguments().getString("from");
        toDateString = getArguments().getString("to");

        fromDate = new Date();
        toDate = new Date();

        fromCalendar = Calendar.getInstance();
        toCalendar = Calendar.getInstance();

        if (!Validators.isNullOrEmpty(fromDateString)) {
            fromDate = CommonFunctions.convertStringDateToDate(fromDateString, "hh:mm a");
            toDate = CommonFunctions.convertStringDateToDate(toDateString, "hh:mm a");
        }

        fromCalendar.setTime(fromDate);
        toCalendar.setTime(toDate);

        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        btnConfirm = view.findViewById(R.id.btnConfirm);
        btnCancel = view.findViewById(R.id.btnCancel);
        tvTitle = view.findViewById(R.id.tvTitle);
        tvFromDate = view.findViewById(R.id.tvFromDate);
        tvToDate = view.findViewById(R.id.tvToDate);
        llFromDate = view.findViewById(R.id.llFromDate);
        llToDate = view.findViewById(R.id.llToDate);
        tvTitle.setText(title);

        tvFromDate.setGravity(Gravity.CENTER);
        tvToDate.setGravity(Gravity.CENTER);

        tvFromDate.setText(fromDateString);
        tvToDate.setText(toDateString);
    }

    private void setListeners() {
        llFromDate.setOnClickListener(view -> {
            TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), fromListener, fromCalendar.get(Calendar.HOUR_OF_DAY), fromCalendar.get(Calendar.MINUTE), false);
            timePickerDialog.show();
            timePickerDialog.setOnCancelListener(dialogInterface -> {

            });

        });
        llToDate.setOnClickListener(view -> {
            TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), toListener, toCalendar.get(Calendar.HOUR_OF_DAY), toCalendar.get(Calendar.MINUTE), false);
            timePickerDialog.show();
            timePickerDialog.setOnCancelListener(dialogInterface -> {

            });
        });
        btnConfirm.setOnClickListener(view -> {
            if (Validators.isNullOrEmpty(fromDateString) || Validators.isNullOrEmpty(toDateString)) {
                ToastUtils.makeToast(getActivity(), "Please select date range");
            } else if (fromCalendar.getTime().getTime() > toCalendar.getTime().getTime()) {
                ToastUtils.makeToast(getActivity(), "Invalid time range selected");
            } else {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(fromDateString, toDateString);
                dismiss();
            }
        });
        btnCancel.setOnClickListener(view -> {
            dismiss();
        });
    }

    TimePickerDialog.OnTimeSetListener fromListener = new TimePickerDialog.OnTimeSetListener() {
        @Override
        public void onTimeSet(TimePicker timePicker, int hour, int minutes) {

            fromCalendar.set(Calendar.HOUR_OF_DAY, hour);
            fromCalendar.set(Calendar.MINUTE, minutes);

            fromDate = fromCalendar.getTime();
            tvFromDate.setText(CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "hh:mm a"));
            fromDateString = tvFromDate.getText().toString();
        }
    };

    TimePickerDialog.OnTimeSetListener toListener = new TimePickerDialog.OnTimeSetListener() {
        @Override
        public void onTimeSet(TimePicker timePicker, int hour, int minutes) {

            toCalendar.set(Calendar.HOUR_OF_DAY, hour);
            toCalendar.set(Calendar.MINUTE, minutes);

            toDate = toCalendar.getTime();
            tvToDate.setText(CommonFunctions.formatMiliToDesireFormat(toDate.getTime(), "hh:mm a"));
            toDateString = tvToDate.getText().toString();
        }
    };
}
