package com.tiffintom.partner1.fragments;

import android.app.DatePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.widget.NestedScrollView;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.R;
import com.tiffintom.partner1.base.BaseBottomSheet;
import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.interfaces.DialogDismissListener;
import com.tiffintom.partner1.interfaces.MoneyTextWatcher;
import com.tiffintom.partner1.models.Voucher;

import java.util.Calendar;

/**
 * Created by Amrish on 22-12-2020.
 */
public class VoucherCodeEditBottomFragment extends BaseBottomSheet {
    public static VoucherCodeEditBottomFragment getInstance(Voucher voucher) {
        VoucherCodeEditBottomFragment voucherCodeEditBottomFragment = new VoucherCodeEditBottomFragment();
        Bundle bundle = new Bundle();
        bundle.putString("voucher", new Gson().toJson(voucher));
        voucherCodeEditBottomFragment.setArguments(bundle);
        return voucherCodeEditBottomFragment;
    }

    DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    Voucher voucher;
    CheckBox cbDelivery, cbDinein, cbCollection;
    RadioGroup rgDevices, rgUses, rgOffer;
    RadioButton rbApp, rbWeb, rbSingle, rbMultiple, rbPrice, rbPercentage, rbFreeDelivery;
    AppCompatEditText etCode, etMultipleTimes, etOfferValue, etMinimumValue;

    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private Calendar today = Calendar.getInstance();
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private TextView tvToDate, tvFromDate;
    private RelativeLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    View shadowDivider;
    NestedScrollView nestedScrollView;
    MaterialButton btnUpdate;
    TextView tvTitle, tvMultipleTimeLabel, tvOfferValueLabel, tvMinimumValueLabel;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            voucher = new Gson().fromJson(getArguments().getString("voucher"), Voucher.class);
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_edit_voucher, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        updateViews();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        ivClose = view.findViewById(R.id.ivClose);
        tvTitle = view.findViewById(R.id.tvTitle);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        shadowDivider = view.findViewById(R.id.shadowDivider);
        nestedScrollView = view.findViewById(R.id.nestedScroll);
        tvToDate = view.findViewById(R.id.tvToDate);
        tvFromDate = view.findViewById(R.id.tvFromDate);
        llToDate = view.findViewById(R.id.llToDate);
        llFromDate = view.findViewById(R.id.llFromDate);

        cbCollection = view.findViewById(R.id.cbCollection);
        cbDinein = view.findViewById(R.id.cbDinein);
        cbDelivery = view.findViewById(R.id.cbDelivery);

        rgDevices = view.findViewById(R.id.rgDevices);
        rgUses = view.findViewById(R.id.rgUses);
        rgOffer = view.findViewById(R.id.rgOffer);

        rbApp = view.findViewById(R.id.rbApp);
        rbWeb = view.findViewById(R.id.rbWeb);
        rbSingle = view.findViewById(R.id.rbSingle);
        rbMultiple = view.findViewById(R.id.rbMultiple);
        rbPrice = view.findViewById(R.id.rbPrice);
        rbPercentage = view.findViewById(R.id.rbPercentage);
        rbFreeDelivery = view.findViewById(R.id.rbFreeDelivery);

        etCode = view.findViewById(R.id.etCode);
        etMultipleTimes = view.findViewById(R.id.etMultipleTimes);
        etOfferValue = view.findViewById(R.id.etOfferValue);
        etMinimumValue = view.findViewById(R.id.etMin);

        tvMultipleTimeLabel = view.findViewById(R.id.tvMultipleTimeLabel);
        tvOfferValueLabel = view.findViewById(R.id.tvOfferValueLabel);
        tvMinimumValueLabel = view.findViewById(R.id.tvMinimumValueLabel);
    }

    @Override
    protected void setListeners() {
        super.setListeners();

        etOfferValue.addTextChangedListener(new MoneyTextWatcher(etOfferValue));
        etMinimumValue.addTextChangedListener(new MoneyTextWatcher(etMinimumValue));
        nestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener) (v, scrollX, scrollY, oldScrollX, oldScrollY) -> {
            if (scrollY == 0) {
                shadowDivider.setVisibility(View.INVISIBLE);
            } else {
                shadowDivider.setVisibility(View.VISIBLE);
            }
        });
        cbDelivery.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) voucher.delivery_type = true;
            else voucher.delivery_type = false;
        });
        cbDinein.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) voucher.dinein_type = true;
            else voucher.dinein_type = false;
        });
        cbCollection.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) voucher.pickup_type = true;
            else voucher.pickup_type = false;
        });
        rgDevices.setOnCheckedChangeListener((radioGroup, i) -> {
            if (i == R.id.rbWeb) {
                voucher.device_type = "web";
            } else if (i == R.id.rbApp) {
                voucher.device_type = "app";
            }
        });

        rgOffer.setOnCheckedChangeListener((radioGroup, i) -> {
            if (i == R.id.rbPercentage) {
                voucher.offer_mode = "percentage";
                etOfferValue.setVisibility(View.VISIBLE);
                tvOfferValueLabel.setVisibility(View.VISIBLE);
            } else if (i == R.id.rbPrice) {
                voucher.offer_mode = "price";
                etOfferValue.setVisibility(View.VISIBLE);
                tvOfferValueLabel.setVisibility(View.VISIBLE);
            } else if (i == R.id.rbFreeDelivery) {
                voucher.offer_mode = "free_delivery";
                etOfferValue.setVisibility(View.GONE);
                tvOfferValueLabel.setVisibility(View.GONE);
                voucher.offer_value = 0;
            }
        });
        rgUses.setOnCheckedChangeListener((radioGroup, i) -> {
            if (i == R.id.rbSingle && rbSingle.isChecked()) {
                voucher.type_offer = "single";
                etMultipleTimes.setVisibility(View.GONE);
                tvMultipleTimeLabel.setVisibility(View.GONE);
                etMultipleTimes.setText("");
                voucher.multiple_value = 0;
            } else {
                voucher.type_offer = "multiple";
                etMultipleTimes.setVisibility(View.VISIBLE);
                tvMultipleTimeLabel.setVisibility(View.VISIBLE);
            }
        });
        llFromDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                fromDay = d;
                fromMonth = m;
                fromYear = y;
                fromCalendar.set(y, m, d);
                fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd-MM-yyyy");
                tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(toDate)) {
                datePickerDialog.getDatePicker().setMaxDate(toCalendar.getTimeInMillis());
            }

        });
        llToDate.setOnClickListener(view -> {
            DatePickerDialog datePickerDialog = new DatePickerDialog(getActivity(), (datePicker, y, m, d) -> {
                toDay = d;
                toMonth = m;
                toYear = y;
                toCalendar.set(y, m, d);
                toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd-MM-yyyy");
                tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
            datePickerDialog.show();
            if (!Validators.isNullOrEmpty(fromDate)) {
                datePickerDialog.getDatePicker().setMinDate(fromCalendar.getTimeInMillis());
            }

        });
        btnUpdate.setOnClickListener(view -> {
            if (Validators.isNullOrEmpty(etCode.getText().toString())) {
                etCode.setError("Please enter code");
                etCode.requestFocus();
            } else if (rgUses.getCheckedRadioButtonId() == R.id.rbMultiple && Validators.isNullOrEmpty(etMultipleTimes.getText().toString())) {
                etMultipleTimes.setError("Please enter multiple time value");
                etMultipleTimes.requestFocus();
            } else if (rgOffer.getCheckedRadioButtonId() != R.id.rbFreeDelivery && Validators.isNullOrEmpty(etOfferValue.getText().toString())) {
                etOfferValue.setError("Please enter offer value");
                etOfferValue.requestFocus();
            } else if (Validators.isNullOrEmpty(etMinimumValue.getText().toString())) {
                etMinimumValue.setError("Please enter order minimum value");
                etMinimumValue.requestFocus();
            } else if (rgUses.getCheckedRadioButtonId() == R.id.rbMultiple && (Integer.parseInt(etMultipleTimes.getText().toString().replace(",", "")) == 0)) {
                etMultipleTimes.setError("Multiple times should be greater then 0");
                etMultipleTimes.requestFocus();
            } else if (rgOffer.getCheckedRadioButtonId() != R.id.rbFreeDelivery && Float.parseFloat(etOfferValue.getText().toString().replace(",", "")) == 0) {
                etOfferValue.setError("Offer value should be greater then 0");
                etOfferValue.requestFocus();
            } else if (Float.parseFloat(etMinimumValue.getText().toString().replace(",", "")) == 0) {
                etMinimumValue.setError("Minimum value should be greater then 0");
                etMinimumValue.requestFocus();
            } else {
                voucher.voucher_code = etCode.getText().toString();
                if (!Validators.isNullOrEmpty(etMultipleTimes.getText().toString()))
                    voucher.multiple_value = Integer.parseInt(etMultipleTimes.getText().toString());
                if (!Validators.isNullOrEmpty(etOfferValue.getText().toString()) && !rbFreeDelivery.isChecked()) {
                    voucher.offer_value = Float.parseFloat(etOfferValue.getText().toString().replace(",", ""));
                }
                voucher.minimum_value = Float.parseFloat(etMinimumValue.getText().toString().replace(",", ""));
                voucher.voucher_from = fromDate;
                voucher.voucher_to = toDate;
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(voucher);
                    dismiss();
                }
            }
        });
    }

    private void updateViews() {
        if (voucher != null && !Validators.isNullOrEmpty(voucher.id)) {

            btnUpdate.setText("Update");
            tvTitle.setText("Update Discount Code");
            etCode.setText(voucher.voucher_code);
            etMinimumValue.setText("" + MyApp.df.format(voucher.minimum_value));
            etMultipleTimes.setText("" + voucher.multiple_value);
            etOfferValue.setText("" + MyApp.df.format(voucher.offer_value));

            etCode.setSelection(etCode.getText().toString().length());
            etMinimumValue.setSelection(etMinimumValue.getText().toString().length());
            etMultipleTimes.setSelection(etMultipleTimes.getText().toString().length());
            etOfferValue.setSelection(etOfferValue.getText().toString().length());

            cbDelivery.setChecked(voucher.delivery_type == true);
            cbCollection.setChecked(voucher.pickup_type == true);
            cbDinein.setChecked(voucher.dinein_type == true);

            if (voucher.type_offer.equalsIgnoreCase("single")) {
                rgUses.check(R.id.rbSingle);
            } else {
                rgUses.check(R.id.rbMultiple);
            }

            if (voucher.offer_mode.equalsIgnoreCase("percentage")) {
                rgOffer.check(R.id.rbPercentage);
            } else if (voucher.offer_mode.equalsIgnoreCase("price")) {
                rgOffer.check(R.id.rbPrice);
            } else {
                rgOffer.check(R.id.rbFreeDelivery);
            }

            if (voucher.device_type.equalsIgnoreCase("app")) {
                rgDevices.check(R.id.rbApp);
            } else {
                rgDevices.check(R.id.rbWeb);
            }
            fromCalendar.setTime(CommonFunctions.convertStringDateToDate(voucher.voucher_from, "dd-MM-yyyy"));
            toCalendar.setTime(CommonFunctions.convertStringDateToDate(voucher.voucher_to, "dd-MM-yyyy"));
        } else {
            btnUpdate.setText("Add");
            tvTitle.setText("Add Discount Code");
            toCalendar.add(Calendar.DAY_OF_MONTH, +6);
            voucher = new Voucher();
            voucher.restaurant_id = loggedInRestaurant.id;
            voucher.delivery_type = true;
            voucher.offer_mode = "price";
            voucher.device_type = "app";
            voucher.type_offer = "single";
            cbDelivery.setChecked(true);
            rgOffer.check(R.id.rbPrice);
            rgDevices.check(R.id.rbApp);
            rgUses.check(R.id.rbSingle);
        }

        fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd-MM-yyyy");
        toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd-MM-yyyy");

        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));

    }
}
