package com.tiffintom.partner1.interfaces;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.tiffintom.partner1.common.Validators;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;

public class MoneyTextWatcher implements TextWatcher {
    DecimalFormat doubleFormat;
    private final WeakReference<EditText> editTextWeakReference;

    public MoneyTextWatcher(EditText mEditText) {
        doubleFormat = new DecimalFormat("###,###,##0.00");
        doubleFormat.setMinimumFractionDigits(2);
        editTextWeakReference = new WeakReference<EditText>(mEditText);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {

        EditText editTex = editTextWeakReference.get();
        if (!s.toString().equals(editTex.getText())) {
            try {
                editTex.removeTextChangedListener(this);
                if (!Validators.isNullOrEmpty(s.toString())) {
                    String cleanString = s.toString().replaceAll("[£,.]", "");
                    double parsed = Double.parseDouble(cleanString.replaceAll("[^\\d]", ""));
                    String new_string = doubleFormat.format(parsed / 100);
                    editTex.setText(new_string);
                    editTex.setSelection(new_string.length());
                    editTex.addTextChangedListener(this);
                } else {
                    String new_string = doubleFormat.format(0 / 100);
                    editTex.setText(new_string);
                    editTex.setSelection(new_string.length());
                    editTex.addTextChangedListener(this);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    @Override
    public void afterTextChanged(Editable s) {

    }
}
