package com.tiffintom.partner1.models;


import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import java.util.Objects;

@Entity
public class CountryCom {
    /*
        "id": 3,
                "name": "United Kingdom",
                "phone_code": "44",
                "iso": "GB",
                "iso3": "GBR",
                "currency_name": "Pound",
                "currency_code": "GBP",
                "currency_symbol": "£",
                "image": null,
                "created_at": "2021-02-16T10:12:14.000000Z"*/
    @NonNull
    @PrimaryKey(autoGenerate = false)
    public int id;//: 0,
    public String phone_code;//: 9,
    public String iso;//: 9,
    public String iso3;//: 2,
    public String currency_name;//: 0
    public String currency_code;//: 0
    public String currency_symbol;//: 0
    public String image;//: 0
    public String created_at;//: 0

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CountryCom customer = (CountryCom) o;
        return Objects.equals(id, customer.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
