package com.tiffintom.partner1.network

import com.google.gson.GsonBuilder
import com.stripe.stripeterminal.external.models.ConnectionTokenException
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.io.IOException


/**
 * The `ApiClient` is a singleton object used to make calls to our backend and return their results
 */
object ApiClient {
    var gson = GsonBuilder()
        .setLenient()
        .create()
    private val client = OkHttpClient.Builder()
        .addInterceptor(NetworkInterceptor())
        .build()
    private val retrofit: Retrofit = Retrofit.Builder()
        .baseUrl(ApiEndPoints.CARD_READER_TOKEN)
        .client(client)
        .addConverterFactory(GsonConverterFactory.create(gson))
        .build()
    private val service: BackendService = retrofit.create(BackendService::class.java)

    @Throws(ConnectionTokenException::class)
    internal fun createConnectionToken(s_location_id: String, businessId: String): String {
        try {
            val result =
                service.getConnectionToken(s_location_id = s_location_id, business_id = businessId)
                    .execute()
            if (result.isSuccessful && result.body() != null) {
                return result.body()!!.secret
            } else {
                throw ConnectionTokenException("Creating connection token failed")
            }
        } catch (e: IOException) {
            throw ConnectionTokenException("Creating connection token failed", e)
        }
    }
}