package com.tiffintom.partner1.network

import retrofit2.Call
import retrofit2.http.Field
import retrofit2.http.FieldMap
import retrofit2.http.FormUrlEncoded
import retrofit2.http.POST

/**
 * The `BackendService` interface handles the two simple calls we need to make to our backend.
 */
interface BackendService {

    /**
     * Get a connection token string from the backend
     */
    @FormUrlEncoded
    @POST("card-reader-connection-token")
    fun getConnectionToken(
        @Field("s_location_id") s_location_id: String="",
        @Field("business_id") business_id: String ="",
    ): Call<ConnectionToken>

}