package com.tiffintom.partner1.network;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.utils.EasyAES;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
 * Created by Amrish on 19-08-2020.
 */
public class NetworkInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {

        Request originalRequest = chain.request();
        Response response = null;
        try {
            Request.Builder tokenRequestBuilder = originalRequest.newBuilder();
            Map<String, String> headers = null;
            headers = MyApp.getInstance().getMyPreferences().getBusinessToken();
            tokenRequestBuilder.addHeader("package-name", MyApp.getInstance().getPackageName());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    tokenRequestBuilder.header(entry.getKey(), entry.getValue());
                }
            }

            response = chain.proceed(tokenRequestBuilder.build());
            String xToken = response.header("x-token", null);
            String xRefreshToken = response.header("x-refresh-token", null);
            if (xToken != null && xRefreshToken != null) {
                MyApp.getInstance().getMyPreferences().saveBusinessToken(xToken, xRefreshToken);
            }
            if (response.code() == 200) {
                String enc_data = "" + response.body().string();
                Log.e("enc_dataenc_data", "enc_data "+enc_data);
                if(enc_data.length()>87){
                    StringBuilder stringBuilder = new StringBuilder(enc_data);
                    stringBuilder.replace(0,15,"");
                    stringBuilder.replace(8,15,"");
                    stringBuilder.replace(14,22,"");
                    stringBuilder.replace(22,28,"");
                    stringBuilder.replace(28,35,"");
                    stringBuilder.replace(stringBuilder.length()-18,stringBuilder.length()-3,"");
                    enc_data= EasyAES.decryptString(stringBuilder.toString());
                }else{
                    enc_data= EasyAES.decryptString(enc_data);
                }
                return response.newBuilder()
                        .body(ResponseBody.create(response.body().contentType(), enc_data)).build();
            }
        } catch (UnknownHostException e) {

            new Handler(Looper.getMainLooper())
                    .post(() -> {
//                        ToastUtils.makeToast(MyApp.getInstance().getApplicationContext(), "No internet connection");
//                        MyApp.getInstance().getApplicationContext().startActivity(new Intent(MyApp.getInstance().getApplicationContext(), NoInternetActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                    });
            throw e;
        } catch (IOException e) {
            e.printStackTrace();

            new Handler(Looper.getMainLooper())
                    .post(() -> {
//                        ToastUtils.makeToast(MyApp.getInstance().getApplicationContext(), "No internet connection");
//                        MyApp.getInstance().getApplicationContext().startActivity(new Intent(MyApp.getInstance().getApplicationContext(), NoInternetActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                    });
//                            Toast.makeText(myApp.getApplicationContext(),
//                            "No internet connection!", Toast.LENGTH_SHORT).show());
            throw e;
        }

        return response;
    }
}
