package com.tiffintom.partner1.notification;

import static com.tiffintom.partner1.utils.Constants.AUTO_ACCEPT;
import static com.tiffintom.partner1.utils.Constants.BOOKING_ID;
import static com.tiffintom.partner1.utils.Constants.ORDER_ID;
import static com.tiffintom.partner1.utils.Constants.PREPARATION_TIME;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.tiffintom.partner1.activities.HomeActivity;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;

import org.json.JSONException;
import org.json.JSONObject;


public class MyFirebaseMessagingService extends FirebaseMessagingService {

    private static final String TAG = MyFirebaseMessagingService.class.getSimpleName();
    private NotificationUtils notificationUtils;
    String message = "", title = "";

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        LogUtils.e("FCM: " + remoteMessage.getFrom());
        if (remoteMessage.getNotification() != null)
            LogUtils.e("FCM: " + remoteMessage.getNotification().getTitle());

        // Check if message contains a notification payload.
        if (remoteMessage.getNotification() != null) {
            // handleNotification(remoteMessage.getNotification().getBody());
        }
        int booking_id = 0;
        String preparation_time = null;
        String order_id = null;
        boolean auto_accept = false;
        if (remoteMessage.getData().size() > 0) {
            try {
                JSONObject json = new JSONObject(remoteMessage.getData().toString());
                Log.e("getData", " " + json.toString());
                if(json!=null && json.has("data")){
                    JSONObject data = json.getJSONObject("data");
                    if (data.has(ORDER_ID))
                        order_id = data.getString(ORDER_ID);
                    if (data.has(AUTO_ACCEPT))
                        auto_accept = data.getBoolean(AUTO_ACCEPT);
                    if (data.has(BOOKING_ID))
                        booking_id = data.getInt(BOOKING_ID);
                    if (data.has(PREPARATION_TIME))
                        preparation_time = data.getString(PREPARATION_TIME);
                }
                handleDataMessage(json);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        Intent pushNotification = new Intent(Constants.NOTIFICATION);
        pushNotification.putExtra("refresh", true);
        pushNotification.putExtra("orders", true);
        pushNotification.putExtra("reservations", true);
        pushNotification.putExtra("chat", true);
        pushNotification.putExtra("reviews", true);
        // add order and booking related field in extra
        pushNotification.putExtra(BOOKING_ID, booking_id);
        pushNotification.putExtra(AUTO_ACCEPT, auto_accept);
        pushNotification.putExtra(PREPARATION_TIME, preparation_time);
        pushNotification.putExtra(ORDER_ID, order_id);
        LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
    }

    private void handleNotification(String message) {
        if (!NotificationUtils.isAppIsInBackground(getApplicationContext())) {
            // app is in foreground, broadcast the push message
            Intent pushNotification = new Intent(Constants.NOTIFICATION);
            pushNotification.putExtra("refresh", true);
            LocalBroadcastManager.getInstance(this).sendBroadcast(pushNotification);


            NotificationUtils notificationUtils = new NotificationUtils(getApplicationContext());
            notificationUtils.playNotificationSound();

        }
    }

    private void handleDataMessage(JSONObject json) {
        LogUtils.e("Notification Response: " + json.toString());

        try {
            JSONObject data = json.getJSONObject("data");

            title = data.getString("title");
            message = data.getString("message");
            String timestamp = data.getString("timestamp");

            if (!NotificationUtils.isAppIsInBackground(getApplicationContext())) {
                // app is in foreground, broadcast the push message
                Intent pushNotification = new Intent(Constants.NOTIFICATION);
                pushNotification.putExtra("refresh", true);
                if (title.equalsIgnoreCase("payment")) {
                    if (data.has("amount")) {
                        pushNotification.putExtra("amount", data.getString("amount"));
                    }
                    if (data.has("status")) {
                        pushNotification.putExtra("status", data.getString("status"));
                    }
                    if (data.has("transaction_id")) {
                        pushNotification.putExtra("transaction_id", data.getString("transaction_id"));
                    }
                    if (data.has("email")) {
                        pushNotification.putExtra("email", data.getString("email"));
                    }
                    if (data.has("phone")) {
                        pushNotification.putExtra("phone", data.getString("phone"));
                    }
                    pushNotification.putExtra("paymentDone", true);
                }
                LocalBroadcastManager.getInstance(this).sendBroadcast(pushNotification);

                // play notification sound
                NotificationUtils notificationUtils = new NotificationUtils(getApplicationContext());
                notificationUtils.playNotificationSound();

                Intent resultIntent = new Intent(getApplicationContext(), HomeActivity.class);
                if (title.equalsIgnoreCase("newtable")) {
                    resultIntent.putExtra("destination", "reservations");
                } else if (title.equalsIgnoreCase("payment")) {
                    if (data.has("amount")) {
                        resultIntent.putExtra("amount", data.getString("amount"));
                    }
                    if (data.has("status")) {
                        resultIntent.putExtra("status", data.getString("status"));
                    }
                    if (data.has("transaction_id")) {
                        resultIntent.putExtra("transaction_id", data.getString("transaction_id"));
                    }
                    if (data.has("email")) {
                        resultIntent.putExtra("email", data.getString("email"));
                    }
                    if (data.has("phone")) {
                        resultIntent.putExtra("phone", data.getString("phone"));
                    }
                } else {
                    resultIntent.putExtra("destination", "orders");
                }
                showNotificationMessage(getApplicationContext(), title, message, timestamp, resultIntent);


            } else if (NotificationUtils.isAppIsInBackground(getApplicationContext())) {
                Intent resultIntent = new Intent(getApplicationContext(), HomeActivity.class);
                if (title.equalsIgnoreCase("newtable")) {
                    resultIntent.putExtra("destination", "reservations");
                } else if (title.equalsIgnoreCase("payment")) {
                    if (data.has("amount")) {
                        resultIntent.putExtra("amount", data.getString("amount"));
                    }
                    if (data.has("status")) {
                        resultIntent.putExtra("status", data.getString("status"));
                    }
                    if (data.has("transaction_id")) {
                        resultIntent.putExtra("transaction_id", data.getString("transaction_id"));
                    }
                    if (data.has("email")) {
                        resultIntent.putExtra("email", data.getString("email"));
                    }
                    if (data.has("phone")) {
                        resultIntent.putExtra("phone", data.getString("phone"));
                    }
                } else {
                    resultIntent.putExtra("destination", "orders");
                }
                showNotificationMessage(getApplicationContext(), title, message, timestamp, resultIntent);


            } else {
                Intent resultIntent = new Intent(getApplicationContext(), HomeActivity.class);
                if (title.equalsIgnoreCase("newtable")) {
                    resultIntent.putExtra("destination", "reservations");
                } else if (title.equalsIgnoreCase("payment")) {
                    if (data.has("amount")) {
                        resultIntent.putExtra("amount", data.getString("amount"));
                    }
                    if (data.has("status")) {
                        resultIntent.putExtra("status", data.getString("status"));
                    }
                    if (data.has("transaction_id")) {
                        resultIntent.putExtra("transaction_id", data.getString("transaction_id"));
                    }
                    if (data.has("email")) {
                        resultIntent.putExtra("email", data.getString("email"));
                    }
                    if (data.has("phone")) {
                        resultIntent.putExtra("phone", data.getString("phone"));
                    }
                } else {
                    resultIntent.putExtra("destination", "orders");
                }
                showNotificationMessage(getApplicationContext(), title, message, timestamp, resultIntent);
            }
        } catch (JSONException e) {
            LogUtils.e(TAG, "Json Exception: " + e.getMessage());
        } catch (Exception e) {
            LogUtils.e(TAG, "Exception: " + e.getMessage());
        }
    }

    /**
     * Showing notification with text only
     */
    private void showNotificationMessage(Context context, String title, String message, String timeStamp, Intent intent) {
        String notTitle = null;
        try {
            notTitle = "";
            if (title.equalsIgnoreCase("payment")) {
                notTitle = "Payment Notification - " + intent.getStringExtra("phone");
            } else {
                notTitle = "TiffinTom Restaurant";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        notificationUtils.showNotificationMessage(notTitle, message, timeStamp, intent);
    }

    @Override
    public void onNewToken(@NonNull String s) {
        super.onNewToken(s);
        // MyApp.getInstance().getMyPreferences().setUserFCMToken(s);
    }
}
