package com.tiffintom.partner1.services_receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

public class CheckConnectivity extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent arg1) {
        try {
            ConnectivityManager manager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo ni = manager.getActiveNetworkInfo();
            if (ni != null && ni.getState() == NetworkInfo.State.CONNECTED) {
                Intent pushNotification = new Intent("NetworkChange");
                Toast.makeText(context, "Internet Connected", Toast.LENGTH_LONG).show();
                pushNotification.putExtra("isConnected", true);
                LocalBroadcastManager.getInstance(context).sendBroadcast(pushNotification);
            } else if (arg1.getBooleanExtra(ConnectivityManager.EXTRA_NO_CONNECTIVITY, Boolean.FALSE)) {
                Intent pushNotification = new Intent("NetworkChange");
                Toast.makeText(context, "Internet Connection Lost", Toast.LENGTH_LONG).show();
                pushNotification.putExtra("isConnected", false);
                LocalBroadcastManager.getInstance(context).sendBroadcast(pushNotification);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}