package com.tiffintom.partner1.services_receivers;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.tiffintom.partner1.utils.LogUtils;

public class DeviceBootReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            LogUtils.e("Boot Completed");
            Intent alarmIntent = new Intent(context, ReminderBroadCastManager.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, alarmIntent, PendingIntent.FLAG_MUTABLE);

            AlarmManager manager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

            int interval = 8000;

            manager.setInexactRepeating(AlarmManager.RTC_WAKEUP,
                    System.currentTimeMillis(), interval, pendingIntent);
            Intent broadcastIntent = new Intent(context, ServiceStopReceiver.class);
            context.sendBroadcast(broadcastIntent);

        }
    }
}