package com.tiffintom.partner1.services_receivers;

import static android.content.Context.ALARM_SERVICE;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;

import com.tiffintom.partner1.common.CommonFunctions;
import com.tiffintom.partner1.utils.LogUtils;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class NotificationScheduler {
    public static final int DAILY_REMINDER_REQUEST_CODE = 100;
    public static final String TAG = "NotificationScheduler";

    public static void setReminder(Context context, int month, int date, int hour, int minute) {
        Calendar cur_cal = new GregorianCalendar();
        cur_cal.setTimeInMillis(System.currentTimeMillis());//set the current time and date for this calendar

        ComponentName receiver = new ComponentName(context, ReminderBroadCastManager.class);
        PackageManager pm = context.getPackageManager();
        pm.setComponentEnabledSetting(receiver,
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);

        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.YEAR, cur_cal.get(Calendar.YEAR));
        cal.set(Calendar.MONTH, month);
        cal.add(Calendar.DATE, date);
        cal.set(Calendar.HOUR_OF_DAY, hour);
        cal.set(Calendar.MINUTE, minute);
        cal.set(Calendar.SECOND, cur_cal.get(Calendar.SECOND));
        cal.set(Calendar.MILLISECOND, cur_cal.get(Calendar.MILLISECOND));
        Intent intent = new Intent(context, ReminderBroadCastManager.class);

        intent.putExtra("placedTime", CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a"));
        intent.putExtra("targetTime", CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd-MM-yyyy hh:mm:ss a"));
        PendingIntent pintent = PendingIntent.getBroadcast(context, DAILY_REMINDER_REQUEST_CODE, intent, PendingIntent.FLAG_UPDATE_CURRENT);
        AlarmManager alarm = (AlarmManager) context.getSystemService(ALARM_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            alarm.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, cal.getTimeInMillis(), pintent);
        } else {
            alarm.setExact(AlarmManager.RTC_WAKEUP, cal.getTimeInMillis(), pintent);
        }
        LogUtils.e("Future Time:: ", CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd-MM-yyyy hh:mm:ss a"));

    }

    public static void cancelReminder(Context context, Class<?> cls) {
        // Disable a receiver

        ComponentName receiver = new ComponentName(context, cls);
        PackageManager pm = context.getPackageManager();

        pm.setComponentEnabledSetting(receiver,
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);

        Intent intent1 = new Intent(context, cls);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, DAILY_REMINDER_REQUEST_CODE, intent1, PendingIntent.FLAG_UPDATE_CURRENT);
        AlarmManager am = (AlarmManager) context.getSystemService(ALARM_SERVICE);
        am.cancel(pendingIntent);
        pendingIntent.cancel();
    }
}