package com.tiffintom.partner1.services_receivers;

import static com.tiffintom.partner1.common.CommonFunctions.isConnected;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Intent;
import android.util.Log;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.models.Counts;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.notification.NotificationUtils;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;

import java.util.HashMap;

public class TiffintomPartnerJobService extends JobService {

    private MyApp myApp = MyApp.getInstance();

    @Override
    public boolean onStartJob(JobParameters params) {
        myApp.schedulerJob(getApplicationContext()); // reschedule the job
        Log.e("Job service", "onStartJob");
        try {
            if (isConnected(getApplicationContext())) {
                if (myApp.getMyPreferences().getMerchantBusinesses()!=null && !myApp.getMyPreferences().getMerchantBusinesses().online_service || !myApp.getMyPreferences().isOnlineOrderEnable()) {
                    MyApp.getInstance().stopOrderSound();
                    MyApp.getInstance().stopNewMessageSound();
                    MyApp.getInstance().stopBookingSound();
                    MyApp.getInstance().stopDelayedOrderSound();
                    Intent pushNotification = new Intent(Constants.NOTIFICATION);
                    pushNotification.putExtra("refresh", true);
                    LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
                    LogUtils.e("ORDER STATUS CALLED");
                } else if (MyApp.getInstance().getMyPreferences().getLoggedInRestaurant() != null || myApp.getMyPreferences().isOnlineOrderEnable()) {//when online order is off
                    LogUtils.e("FETCH COUNT CALLED");
                    fetchCounts();
                }

            }

          /*  if (isConnected(getApplicationContext()) && MyApp.getInstance().getMyPreferences().getLoggedInRestaurant() != null) {
                fetchCounts();
            }*/
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return true;
    }

    @Override
    public void onDestroy() {
        try {
            Intent broadcastIntent = new Intent(this, ServiceStopReceiver.class);
            sendBroadcast(broadcastIntent);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }


    boolean lastBroadcastSent = false;

    public void fetchCounts() {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("customer_id", MyApp.getInstance().getMyPreferences().getLoggedInMerchant().id);
            params.put("restaurant_id", MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().id);
            AndroidNetworking.get(ApiEndPoints.restaurants + MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().id + "/counts")
                    .build()
                    .getAsObject(Counts.class, new ParsedRequestListener<Counts>() {
                        @Override
                        public void onResponse(Counts response) {
                            try {
                                //   LogUtils.e("Count Response: ", new Gson().toJson(response));
                                Intent pushNotification = new Intent(Constants.NOTIFICATION);
                                pushNotification.putExtra("refresh", true);
                                pushNotification.putExtra("counts", new Gson().toJson(response));

                                if (NotificationUtils.isAppIsInBackground(getApplicationContext())) {
                                    LogUtils.e("App in Background");
                                    MyApp.getInstance().startOrderSound();
                                }
                                if (response.pending_orders > 0) {
                                    pushNotification.putExtra("orders", true);
                                    lastBroadcastSent = false;
                                } else {
                                    if (!lastBroadcastSent)
                                        pushNotification.putExtra("orders", true);
                                    lastBroadcastSent = true;
                                }
                                if (response.pending_bookings > 0) {
                                    pushNotification.putExtra("reservations", true);
                                }
                                if (response.new_reviews > 0) {
                                    pushNotification.putExtra("reviews", true);
                                }
                                if (response.delay_orders > 0) {
                                    lastBroadcastSent = false;
                                    pushNotification.putExtra("orders", true);
                                } else {
                                    if (!lastBroadcastSent)
                                        pushNotification.putExtra("orders", true);
                                    lastBroadcastSent = true;
                                }
                                if (response.unread_chat > 0) {
                                    pushNotification.putExtra("chat", true);
                                }
                                LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
