package com.tiffintom.partner1.services_receivers;

import static com.tiffintom.partner1.common.CommonFunctions.isConnected;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;

import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.tiffintom.partner1.MyApp;
import com.tiffintom.partner1.models.Counts;
import com.tiffintom.partner1.network.ApiEndPoints;
import com.tiffintom.partner1.notification.NotificationUtils;
import com.tiffintom.partner1.utils.Constants;
import com.tiffintom.partner1.utils.LogUtils;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by Amrish on 27-11-2020.
 */
public class TiffintomPartnerService extends Service {
    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }


    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        LogUtils.e("SERVICE", "onstart!");
        try {
            startTimer();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return START_STICKY;
    }


    @Override
    public void onDestroy() {
        LogUtils.e("SERVICE", "ondestroy!");
        Intent broadcastIntent = new Intent(this, ServiceStopReceiver.class);
        sendBroadcast(broadcastIntent);
        stoptimertask();
        super.onDestroy();
    }

    private Timer timer;
    private TimerTask timerTask;
    long oldTime = 0;

    public void startTimer() {
        //set a new Timer
        timer = new Timer();

        //initialize the TimerTask's job
        if (isConnected(getApplicationContext()) && MyApp.getInstance().getMyPreferences().getLoggedInRestaurant() != null)
            initTimerTask();
        else LogUtils.e("No internet in notification");
        //schedule the timer, to wake up every 2 second
        try {
            if (timerTask != null) timer.schedule(timerTask, 10000, 30000); //
        } catch (Exception e) {
        }
    }

    private void initTimerTask() {
        timerTask = new TimerTask() {
            public void run() {
                try {
                    if (MyApp.getInstance().getMyPreferences().getLoggedInRestaurant() != null)
                        fetchCounts();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    boolean lastBroadcastSent = false;

    public void fetchCounts() {
       // 'customer_id','restaurant_id',
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("customer_id", MyApp.getInstance().getMyPreferences().getLoggedInMerchant().id);
            params.put("restaurant_id", MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().id);
            AndroidNetworking.get(ApiEndPoints.restaurants+MyApp.getInstance().getMyPreferences().getLoggedInRestaurant().id+"/counts")
                    //.addBodyParameter("action", "Countview")
                    .build()
                    .getAsObject(Counts.class, new ParsedRequestListener<Counts>() {
                        @Override
                        public void onResponse(Counts response) {
                            try {
                                //   LogUtils.e("Count Response: ", new Gson().toJson(response));
                                Intent pushNotification = new Intent(Constants.NOTIFICATION);
                                pushNotification.putExtra("refresh", true);
                                pushNotification.putExtra("counts", new Gson().toJson(response));

                                if (NotificationUtils.isAppIsInBackground(getApplicationContext())) {
                                    LogUtils.e("App in Background");
                                    MyApp.getInstance().startOrderSound();
                                }
                                if (response.pending_orders > 0) {
                                    pushNotification.putExtra("orders", true);
                                    lastBroadcastSent = false;
                                } else {
                                    if (!lastBroadcastSent)
                                        pushNotification.putExtra("orders", true);
                                    lastBroadcastSent = true;
                                }
                                if (response.pending_bookings > 0) {
                                    pushNotification.putExtra("reservations", true);
                                }
                                if (response.new_reviews > 0) {
                                    pushNotification.putExtra("reviews", true);
                                }
                                if (response.delay_orders > 0) {
                                    lastBroadcastSent = false;
                                    pushNotification.putExtra("orders", true);
                                } else {
                                    if (!lastBroadcastSent)
                                        pushNotification.putExtra("orders", true);
                                    lastBroadcastSent = true;
                                }
                                if (response.unread_chat > 0) {
                                    pushNotification.putExtra("chat", true);
                                }
                                LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(pushNotification);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * not needed
     */
    public void stoptimertask() {
        //stop the timer, if it's not already null
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }
}
