package com.tiffintom.partner1.storageutils;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tiffintom.partner1.common.AESCrypt;
import com.tiffintom.partner1.common.Validators;
import com.tiffintom.partner1.models.CardBrandCommission;
import com.tiffintom.partner1.models.CountryCommission;
import com.tiffintom.partner1.models.DeviceRegistration;
import com.tiffintom.partner1.models.Merchant;
import com.tiffintom.partner1.models.MerchantApp;
import com.tiffintom.partner1.models.MerchantBusinesses;
import com.tiffintom.partner1.models.MerchantCardReader;
import com.tiffintom.partner1.models.MerchantPaymentCredentials;
import com.tiffintom.partner1.models.MerchantRestaurant;
import com.tiffintom.partner1.models.RestaurantUser;
import com.tiffintom.partner1.models.SiteSettings;
import com.tiffintom.partner1.utils.Constants;

import java.lang.reflect.Type;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Amrish on 08-08-2020.
 */
public class MyPreferences {
    private Context context;
    private String OLD_PREFERENCE_MERCHANT = "TiffinTom";
    private String OLD_PREFERENCE_NAME = "login";
    private String EncraptionKey = "TiffinTom@2442";
    private SharedPreferences oldMerchantSharedPref, oldUserPreferences;

    private String PREFERENCE_NAME = "TiffintomPartner";
    private String PREFERENCE_MERCHANT = "Merchant";
    private String PREFERENCE_SETTINGS = "SiteSettings";
    private String PREFERENCE_DEVICE = "DeviceDetails";
    private String PREFERENCE_PRINTER = "Printer";
    private String PREFERENCE_CART_RELATED = "Cart";
    private String PREFERENCE_ONLINE = "online";
    private SharedPreferences userPreferences, siteSharedPreferences, onlinePreferences, deviceSharedPref, merchantSharedPref, printerSharedPref;
    private SharedPreferences.Editor editor;

    private String KEY_DATABASE_DETAILS = "database_connection_details";
    private String KEY_ACTIVE_TERMINAL = "active_terminal";
    private String KEY_LOGGED_IN_USER = "logged_in_restaurant";
    private String KEY_LOGGED_IN_USER_PASSWORD = "logged_in_restaurant_password";
    private String KEY_LOGIN_SKIPPED = "login_skipped";
    private String KEY_CURRENT_POSTCODE = "current_postcode";
    private String KEY_CURRENT_ADDRESS = "current_address";
    private String KEY_DEVICE_ID = "device_id";
    private String KEY_FCM_ID = "fcm_id";
    private String KEY_MERCHANT_PAYMENT_CRED = "payment_credentials";
    private String KEY_MERCHANT_APP_DETAILS = "merchant_details";
    private String KEY_MERCHANT_CARD_READER = "cardreader_details";
    private String KEY_MERCHANT = "merchant";
    private String KEY_MERCHANT_ADMIN_LOGGED_IN = "merchant_admin_login";
    private String KEY_MERCHANT_SUPERVISOR_LOGGED_IN = "merchant_supervisor_login";

    private String KEY_MERCHANT_RESTAURANT = "merchant_restaurant";
    private String KEY_MERCHANT_ROLE = "merchant_role";
    private String KEY_MERCHANT_CHART_FOR_0 = "merchant_chart_for_user";
    private String KEY_MERCHANT_CHART_FOR_1 = "merchant_chart_for_supervisor";
    private String KEY_MERCHANT_TRANSACTION_FOR_1 = "merchant_transaction_for_supervisor";
    private String KEY_MERCHANT_TRANSACTION_FOR_0 = "merchant_transaction_for_user";
    private String KEY_MERCHANT_PRINT_REPORT_FOR_1 = "merchant_print_report_for_supervisor";
    private String KEY_MERCHANT_PRINT_REPORT_FOR_0 = "merchant_print_report_for_user";
    private String KEY_PRINTER = "printer";
    private String KEY_PRINTER_IP = "printer_ip";
    private String KEY_ONLINE_ORDER = "online_order";
    private String KEY_ADMIN_CHANGE = "admin_changes";
    private String KEY_CARD_READER_RESTART = "card_reader_restart";
    private static final String KEY_REMEMBER_DETAILS = "remember_me";
    private static final String KEY_SITE_SETTINGS = "fetched_settings";
    private static final String KEY_REFERRAL = "fetched_referrals";
    private static final String KEY_REWARDS = "fetched_rewards";
    private static final String KEY_COUNTRY = "selected_country";  // values should be in IN, UK
    private static final String KEY_APP_INTRO = "app_intro";
    private static final String KEY_DEFAULT_PAYMENT_METHOD = "default_payment_method";
    private String KEY_MERCHANT_BUSINESSES = "merchant_businesses";

    public MyPreferences(Context context) {
        this.context = context;
        //For old version of application. This will use only to access previous data and then we will clear them.
        oldMerchantSharedPref = context.getSharedPreferences(OLD_PREFERENCE_MERCHANT, Context.MODE_PRIVATE);
        oldUserPreferences = context.getSharedPreferences(OLD_PREFERENCE_NAME, Context.MODE_PRIVATE);

        siteSharedPreferences = context.getSharedPreferences(PREFERENCE_SETTINGS, Context.MODE_PRIVATE);
        deviceSharedPref = context.getSharedPreferences(PREFERENCE_DEVICE, Context.MODE_PRIVATE);
        userPreferences = context.getSharedPreferences(PREFERENCE_NAME, Context.MODE_PRIVATE);
        merchantSharedPref = context.getSharedPreferences(PREFERENCE_MERCHANT, Context.MODE_PRIVATE);
        printerSharedPref = context.getSharedPreferences(PREFERENCE_PRINTER, Context.MODE_PRIVATE);
        onlinePreferences = context.getSharedPreferences(PREFERENCE_ONLINE, Context.MODE_PRIVATE);
    }

    // We require "userid"
    public String getOldPrefValue(String key) {
        if (oldUserPreferences != null) {
            String savedValue = oldUserPreferences.getString(key, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return savedValue;
        }
        return null;
    }

    // We require "username", "password","restaurantid","admin_islogin","superviser_islogin","type"==3
    public String getOldMerchantPrefValue(String key) {
        if (oldMerchantSharedPref != null) {
            String savedValue = oldMerchantSharedPref.getString(key, null);
            if (savedValue != null) {
                try {
                    savedValue = AESCrypt.decrypt(EncraptionKey, savedValue);
                } catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return savedValue;
        }
        return null;
    }

    public void saveLoggedInRestaurant(RestaurantUser user) {
        if (userPreferences != null && user != null) {
            SharedPreferences.Editor editor = userPreferences.edit();
            editor.putString(KEY_LOGGED_IN_USER, new Gson().toJson(user));
            editor.apply();
        }
    }

    public RestaurantUser getLoggedInRestaurant() {
        if (userPreferences != null) {
            String savedValue = userPreferences.getString(KEY_LOGGED_IN_USER, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, RestaurantUser.class);
        } else return null;
    }

    public void saveUserP(String p) {
        if (userPreferences != null) {
            SharedPreferences.Editor editor = userPreferences.edit();
            editor.putString(KEY_LOGGED_IN_USER_PASSWORD, p);
            editor.apply();
        }
    }

    public String getUserP() {
        if (userPreferences != null) {
            String savedValue = userPreferences.getString(KEY_LOGGED_IN_USER_PASSWORD, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            else return savedValue;
        }
        return null;
    }

    public void saveAppIntroDone(boolean save) {
        if (deviceSharedPref != null) {
            SharedPreferences.Editor editor = deviceSharedPref.edit();
            editor.putBoolean(KEY_APP_INTRO, save);
            editor.apply();
        }
    }

    public boolean getAppIntroDone() {
        if (deviceSharedPref != null) {
            return deviceSharedPref.getBoolean(KEY_APP_INTRO, false);
        }
        return false;
    }

    public void logout() {
        if (userPreferences != null) {
            userPreferences.edit().clear().apply();
        }
    }

    public void setAndroidDeviceId(String deviceId) {
        if (deviceSharedPref != null) {
            deviceSharedPref.edit().putString(KEY_DEVICE_ID, deviceId).apply();
        }
    }

    public String getAndroidDeviceId() {
        if (deviceSharedPref != null) {
            return deviceSharedPref.getString(KEY_DEVICE_ID, null);
        }
        return null;
    }

    public void setUserFCMToken(String fcmToken) {
        if (deviceSharedPref != null) {
            deviceSharedPref.edit().putString(KEY_FCM_ID, fcmToken).apply();
        }
    }

    public String getUserFCMToken() {
        if (deviceSharedPref != null) {
            return deviceSharedPref.getString(KEY_FCM_ID, "");
        }
        return null;
    }


    public void saveSiteSettings(SiteSettings settings) {
        if (siteSharedPreferences != null) {
            siteSharedPreferences.edit().putString(KEY_SITE_SETTINGS, new Gson().toJson(settings)).apply();
        }
    }

    public void saveCardBrandCommission(List<CardBrandCommission> list) {
        if (siteSharedPreferences != null) {
            Gson gson = new Gson();
            String json = gson.toJson(list);
            siteSharedPreferences.edit().putString("CardBrandCommission", new Gson().toJson(json)).apply();
        }
    }

    public List<CardBrandCommission> getCardBrandCommission() {
        if (siteSharedPreferences != null) {
            String savedValue = siteSharedPreferences.getString("CardBrandCommission", null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            Type type = new TypeToken<List<CardBrandCommission>>() {
            }.getType();
            return new Gson().fromJson(savedValue, type);
        }
        return null;
    }

    public void saveCardCountryCommission(List<CountryCommission> list) {
        if (siteSharedPreferences != null) {
            Gson gson = new Gson();
            String json = gson.toJson(list);
            siteSharedPreferences.edit().putString("CountryCommission", new Gson().toJson(json)).apply();
        }
    }

    public List<CountryCommission> getCardCountryCommission() {
        if (siteSharedPreferences != null) {
            String savedValue = siteSharedPreferences.getString("CountryCommission", null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            Type type = new TypeToken<List<CountryCommission>>() {
            }.getType();
            return new Gson().fromJson(savedValue, type);
        }
        return null;
    }


    public SiteSettings getSiteSettings() {
        if (siteSharedPreferences != null) {
            String savedValue = siteSharedPreferences.getString(KEY_SITE_SETTINGS, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, SiteSettings.class);
        }
        return null;
    }


    public void saveSelectedCountry(String country) {
        if (siteSharedPreferences != null) {
            siteSharedPreferences.edit().putString(KEY_COUNTRY, country).apply();
        }
    }

    public String getSelectedCountry() {
        if (siteSharedPreferences != null) {
            String savedValue = siteSharedPreferences.getString(KEY_COUNTRY, "UK");
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return savedValue;
        }
        return null;
    }


    public void saveMerchantPaymentCredentials(MerchantPaymentCredentials merchantPaymentCredentials) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString(KEY_MERCHANT_PAYMENT_CRED, new Gson().toJson(merchantPaymentCredentials)).apply();
        }
    }

    public MerchantPaymentCredentials getMerchantPaymentCredentials() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString(KEY_MERCHANT_PAYMENT_CRED, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, MerchantPaymentCredentials.class);
        }
        return null;
    }

    public void saveMerchant(Merchant merchant) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString(KEY_MERCHANT, new Gson().toJson(merchant)).apply();
        }
    }

    public Merchant getLoggedInMerchant() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString(KEY_MERCHANT, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, Merchant.class);
        }
        return null;
    }

    public void saveMerchantRestaurant(MerchantRestaurant merchantRestaurant) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString(KEY_MERCHANT_RESTAURANT, new Gson().toJson(merchantRestaurant)).apply();
        }
    }

    public MerchantRestaurant getMerchantRestaurant() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString(KEY_MERCHANT_RESTAURANT, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, MerchantRestaurant.class);
        }
        return null;
    }

    public void saveDeviceRegistration(DeviceRegistration device) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString("device", new Gson().toJson(device)).apply();
        }
    }

    public DeviceRegistration getDeviceRegistration() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString("device", null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, DeviceRegistration.class);
        }
        return null;
    }

    public void saveMerchantBusinesses(MerchantBusinesses businesses) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString(KEY_MERCHANT_BUSINESSES, new Gson().toJson(businesses)).apply();
        }
    }

    public MerchantBusinesses getMerchantBusinesses() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString(KEY_MERCHANT_BUSINESSES, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, MerchantBusinesses.class);
        }
        return null;
    }

    public void saveBusinessId(String business_id) {
        SharedPreferences.Editor editor = merchantSharedPref.edit();
        editor.putString("id", business_id);
        editor.apply();
    }

    public String getBusinessId() {
        return merchantSharedPref.getString("id", null);
    }

    public void saveMerchantAppDetails(MerchantApp merchantApp) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString(KEY_MERCHANT_APP_DETAILS, new Gson().toJson(merchantApp)).apply();
        }
    }

    public MerchantApp getMerchantApp() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString(KEY_MERCHANT_APP_DETAILS, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, MerchantApp.class);
        }
        return null;
    }

    /*<p>
     *0 = normal[Waiter type]
     *1 = supervisor [Manager type]
     *2 = admin [Owner type]
     * @param  role  0= normal user, 1= supervisor, 2=admin
     * */
    public void saveMerchantRole(int role) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putInt(KEY_MERCHANT_ROLE, role).apply();
        }
    }

    public int getMerchantRole() {
        if (merchantSharedPref != null) {
            return merchantSharedPref.getInt(KEY_MERCHANT_ROLE, 0);
        } else return 0;
    }

    public void saveChartPermission(int role, boolean enable) {
        if (merchantSharedPref != null) {
            if (role == 0) {
                merchantSharedPref.edit().putBoolean(KEY_MERCHANT_CHART_FOR_0, enable).apply();
            }
            if (role == 1) {
                merchantSharedPref.edit().putBoolean(KEY_MERCHANT_CHART_FOR_1, enable).apply();
            }

        }
    }

    public boolean getChartPermission(int role) {
        if (merchantSharedPref != null) {
            if (role == 0) {
                return merchantSharedPref.getBoolean(KEY_MERCHANT_CHART_FOR_0, false);
            }
            if (role == 1) {
                return merchantSharedPref.getBoolean(KEY_MERCHANT_CHART_FOR_1, false);
            }
        }
        return true;
    }

    public void saveMerchantTransactionPermission(int role, boolean enable) {
        if (merchantSharedPref != null) {
            if (role == Constants.ROLE_MERCHANT_USER) {
                merchantSharedPref.edit().putBoolean(KEY_MERCHANT_TRANSACTION_FOR_0, enable).apply();
            }
            if (role == Constants.ROLE_MERCHANT_SUPERVISOR) {
                merchantSharedPref.edit().putBoolean(KEY_MERCHANT_TRANSACTION_FOR_1, enable).apply();
            }

        }
    }

    public boolean getMerchantTransactionPermission(int role) {
        if (merchantSharedPref != null) {
            if (role == Constants.ROLE_MERCHANT_USER) {
                return merchantSharedPref.getBoolean(KEY_MERCHANT_TRANSACTION_FOR_0, false);
            }
            if (role == Constants.ROLE_MERCHANT_SUPERVISOR) {
                return merchantSharedPref.getBoolean(KEY_MERCHANT_TRANSACTION_FOR_1, false);
            }
        }
        return true;
    }

    public void savePrintReportPermission(int role, boolean enable) {
        if (merchantSharedPref != null) {
            if (role == Constants.ROLE_MERCHANT_USER) {
                merchantSharedPref.edit().putBoolean(KEY_MERCHANT_PRINT_REPORT_FOR_0, enable).apply();
            }
            if (role == Constants.ROLE_MERCHANT_SUPERVISOR) {
                merchantSharedPref.edit().putBoolean(KEY_MERCHANT_PRINT_REPORT_FOR_1, enable).apply();
            }

        }
    }

    public boolean getPrintReportPermission(int role) {
        if (merchantSharedPref != null) {
            if (role == Constants.ROLE_MERCHANT_USER) {
                return merchantSharedPref.getBoolean(KEY_MERCHANT_PRINT_REPORT_FOR_0, false);
            }
            if (role == Constants.ROLE_MERCHANT_SUPERVISOR) {
                return merchantSharedPref.getBoolean(KEY_MERCHANT_PRINT_REPORT_FOR_1, false);
            }
        }
        return true;
    }

    public void saveDefaultCardReader(MerchantCardReader merchantCardReader) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putString(KEY_MERCHANT_CARD_READER, new Gson().toJson(merchantCardReader)).apply();
        }
    }

    public MerchantCardReader getDefaultCardReader() {
        if (merchantSharedPref != null) {
            String savedValue = merchantSharedPref.getString(KEY_MERCHANT_CARD_READER, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return new Gson().fromJson(savedValue, MerchantCardReader.class);
        }
        return null;
    }

    public void saveDefaultPrinter(String printer) {
        if (printerSharedPref != null) {
            printerSharedPref.edit().putString(KEY_PRINTER, printer).apply();
        }
    }

    public String getDefaultPrinter() {
        if (printerSharedPref != null) {
            String savedValue = printerSharedPref.getString(KEY_PRINTER, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return savedValue;
        }
        return null;
    }

    public void savePrinterIP(String ip) {
        if (printerSharedPref != null) {
            printerSharedPref.edit().putString(KEY_PRINTER_IP, ip).apply();
        }
    }

    public String getPrinterIP() {
        if (printerSharedPref != null) {
            String savedValue = printerSharedPref.getString(KEY_PRINTER_IP, null);
            if (Validators.isNullOrEmpty(savedValue)) return null;
            return savedValue;
        }
        return null;
    }

    public void saveReStartFromCardReader(boolean isChanged) {
        if (userPreferences != null) {
            userPreferences.edit().putBoolean(KEY_CARD_READER_RESTART, isChanged).commit();
        }
    }

    public boolean isReStartFromCardReader() {
        if (userPreferences != null) {
            return userPreferences.getBoolean(KEY_CARD_READER_RESTART, false);
        }
        return false;
    }

    public void saveAdminChangesForOnline(boolean isChanged) {
        if (onlinePreferences != null) {
            onlinePreferences.edit().putBoolean(KEY_ADMIN_CHANGE, isChanged).apply();
        }
    }

    public boolean isAdminChangedOnline() {
        if (onlinePreferences != null) {
            boolean savedValue = onlinePreferences.getBoolean(KEY_ADMIN_CHANGE, false);
            // if (!savedValue) return false;
            return savedValue;
        }
        return false;
    }

    public void saveOnlineOrderStatusAndEnable(boolean isEnable) {
        if (onlinePreferences != null) {
            onlinePreferences.edit().putBoolean(KEY_ONLINE_ORDER, isEnable).apply();
        }
    }

    public boolean isOnlineOrderEnable() {
        if (onlinePreferences != null) {
            boolean savedValue = onlinePreferences.getBoolean(KEY_ONLINE_ORDER, false);
            //  if (Validators.isNullOrEmpty(savedValue)) return null;
            return savedValue;
        }
        return false;
    }

    public void setSupervisorLoggedIn(boolean loggedIn) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putBoolean(KEY_MERCHANT_SUPERVISOR_LOGGED_IN, loggedIn).apply();
        }
    }

    public boolean isSupervisorLoggedIn() {
        if (merchantSharedPref != null) {
            return merchantSharedPref.getBoolean(KEY_MERCHANT_SUPERVISOR_LOGGED_IN, false);

        }
        return false;
    }

    public void setAdminLoggedIn(boolean loggedIn) {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().putBoolean(KEY_MERCHANT_ADMIN_LOGGED_IN, loggedIn).apply();
        }
    }

    public boolean isAdminLoggedIn() {
        if (merchantSharedPref != null) {
            return merchantSharedPref.getBoolean(KEY_MERCHANT_ADMIN_LOGGED_IN, false);

        }
        return false;
    }

    public void logoutMerchant() {
        if (merchantSharedPref != null) {
            merchantSharedPref.edit().clear().apply();
        }
    }

    public void saveBusinessToken(String xToken, String rToken) {
        SharedPreferences.Editor editor = merchantSharedPref.edit();
        editor.putString("x-token", xToken);
        editor.putString("x-refresh-token", rToken);
        editor.apply();
    }

    public String getBusinessToken(String token) {
        return merchantSharedPref.getString(token, null);
    }

    public Map<String, String> getBusinessToken() {

        String xToken = getBusinessToken("x-token");
        String xRefreshToken = getBusinessToken("x-refresh-token");
        String businessId = getBusinessId();

        Map<String, String> map = new HashMap<>();
        if (businessId != null)
            map.put("business-id", businessId);
        if (xToken != null)
            map.put("x-token", xToken);
        if (xRefreshToken != null)
            map.put("x-refresh-token", xRefreshToken);

        return map;
    }

    public void saveIsUsb(boolean isUsb) {
        merchantSharedPref.edit().putBoolean("is_usb_enable", isUsb).apply();
    }

    public boolean getIsUbEnableStatus() {
        return merchantSharedPref.getBoolean("is_usb_enable", false);
    }

    public void saveBatteryLevel(float batteryLevel) {
        merchantSharedPref.edit().putFloat("terminal_battery_level", batteryLevel).apply();
    }

    public float getBatteryLevel() {
        return merchantSharedPref.getFloat("terminal_battery_level", 0F);
    }

    public void saveSerialNumber(String serialNumber) {
        deviceSharedPref.edit().putString("serial_number", serialNumber).apply();
    }

    public String getSerialNumber() {
        return deviceSharedPref.getString("serial_number", "");
    }

    public void saveLocationId(String locationId) {
        deviceSharedPref.edit().putString("locationId__", locationId).apply();
    }

    public String getLocationId() {
        return deviceSharedPref.getString("locationId__", "");
    }

    public void saveCardReaderConnect(String cardReader) {
        deviceSharedPref.edit().putString("cardReader__", cardReader).apply();
    }

    public String getCardReaderConnect() {
        return deviceSharedPref.getString("cardReader__", "");
    }

    public void savePaymentTheme(String paymentTheme) {
        deviceSharedPref.edit().putString("payment_theme", paymentTheme).apply();
    }

    public String getPaymentTheme() {
        return deviceSharedPref.getString("payment_theme", "theme1");
    }
}
