package com.tiffintom.partner1.utils;

import android.util.Log;

import com.tiffintom.partner1.common.CommonFunctions;

public class LogUtils {
    private static boolean logEnabled = true;
    private static String TAG = "####";

    public static void e(String message) {
        if (logEnabled) Log.e(TAG, message);
    }

    public static void d(String tag, String message) {
        if (logEnabled) Log.d(tag, message);
    }

    public static void d(String message) {
        if (logEnabled) Log.d(TAG, message);
    }

    public static void w(String tag, String message) {
        if (logEnabled) Log.w(tag, message);
    }

    public static void w(String message) {
        if (logEnabled) Log.w(TAG, message);
    }

    public static void e(String... messages) {
        if (logEnabled) Log.e(TAG, CommonFunctions.StringAppender(messages));
    }
}
