package com.tiffintom.partner1.utils;

import android.app.Activity;
import android.content.Context;
import android.widget.Toast;

/**
 * Created by Amrish on 10-08-2020.
 */
public class ToastUtils {
    public static void makeToast(Activity context, String message) {
        if (context != null)
            context.runOnUiThread(() -> Toast.makeText(context, message, Toast.LENGTH_SHORT).show());
    }

    public static void makeLongToast(Activity context, String message) {
        if (context != null)
            context.runOnUiThread(() -> Toast.makeText(context, message, Toast.LENGTH_LONG).show());
    }

    public static void makeToast(Context context, String message) {
        if (context != null)
            Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }

    public static void makeLongToast(Context context, String message) {
        if (context != null)
            Toast.makeText(context, message, Toast.LENGTH_LONG).show();
    }

    public static void makeSnackToast(Activity activity, String message) {
        if (activity != null)
            activity.runOnUiThread(() -> Toast.makeText(activity, message, Toast.LENGTH_LONG).show());
    }
}
