//
//  AudioPlayer.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 10/11/20.
//

import Foundation
import AVFoundation

class CustomAudioPlayer:NSObject,AVAudioPlayerDelegate{
    
    static var audioOrderPlayer:AVAudioPlayer?
    static var audioChatPlayer:AVAudioPlayer?
    static var audioDelayOrderPlayer:AVAudioPlayer?
    var audioPlayer:AVAudioPlayer?
    
    static let shared = CustomAudioPlayer()
    
    deinit {
        if audioPlayer != nil{
            audioPlayer?.stop()
            audioPlayer = nil
            try? AVAudioSession.sharedInstance().setActive(false)
        }
    }
    
    func preparePlayer(soundName:String) {
        guard let url = Bundle.main.url(forResource: soundName, withExtension: "mp3") else { return }
        
        do {
            try AVAudioSession.sharedInstance().setActive(true)
            audioPlayer = try AVAudioPlayer.init(contentsOf: url)
            audioPlayer!.delegate = self
            audioPlayer!.prepareToPlay()
            audioPlayer!.volume = 3.0
            audioPlayer!.rate = 1.0
            
            DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                self.audioPlayer!.play()
                
            }
        } catch let error1 as NSError {
            print("AVAudioPlayer error: \(error1.localizedDescription)")
        }
    }
    
    static func prepareOrderPlayer() {
        
        if audioOrderPlayer != nil{
            return
        }
        guard let url = Bundle.main.url(forResource: "order_alert", withExtension: "mp3") else { return }
        
        do {
            try AVAudioSession.sharedInstance().setActive(true)
            audioOrderPlayer = try AVAudioPlayer.init(contentsOf: url)
            audioOrderPlayer!.prepareToPlay()
            audioOrderPlayer!.volume = 3.0
            audioOrderPlayer!.numberOfLoops = -1
            
            self.audioOrderPlayer!.rate = 1.0
            DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                if self.audioOrderPlayer != nil{
                    self.audioOrderPlayer!.play()
                }
            }
        } catch let error as NSError {
            print("AVAudioPlayer error: \(error.localizedDescription)")
            audioOrderPlayer = nil
        }
    }
    
    static func prepareChatPlayer() {
        
        if audioChatPlayer != nil{
            return
        }
        
        guard let url = Bundle.main.url(forResource: "new_message", withExtension: "mp3") else { return }
        
        do {
            try AVAudioSession.sharedInstance().setActive(true)
            audioChatPlayer = try AVAudioPlayer.init(contentsOf: url)
            audioChatPlayer!.prepareToPlay()
            audioChatPlayer!.volume = 3.0
            audioChatPlayer!.numberOfLoops = -1
            
            self.audioChatPlayer!.rate = 1.0
            DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                if self.audioChatPlayer != nil{
                    self.audioChatPlayer!.play()
                }
            }
        } catch let error as NSError {
            print("AVAudioPlayer error: \(error.localizedDescription)")
            audioChatPlayer = nil
        }
        
    }
    
    static func prepareDalyOrderPlayer() {
        
        if audioDelayOrderPlayer != nil{
            return
        }
        
        guard let url = Bundle.main.url(forResource: "delayed_order", withExtension: "mp3") else { return }
        
        do {
            try AVAudioSession.sharedInstance().setActive(true)
            audioDelayOrderPlayer = try AVAudioPlayer.init(contentsOf: url)
            audioDelayOrderPlayer!.prepareToPlay()
            audioDelayOrderPlayer!.volume = 3.0
            audioDelayOrderPlayer!.numberOfLoops = -1
            
            self.audioDelayOrderPlayer!.rate = 1.0
            DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                if self.audioDelayOrderPlayer != nil{
                    self.audioDelayOrderPlayer!.play()
                }
            }
        } catch let error as NSError {
            print("AVAudioPlayer error: \(error.localizedDescription)")
            audioDelayOrderPlayer = nil
        }
    }
    
    static func stopOrderAudio(){
        if audioOrderPlayer != nil{
            audioOrderPlayer!.stop()
            audioOrderPlayer = nil
            try? AVAudioSession.sharedInstance().setActive(false)
        }
    }
    
    static func stopChatAudio(){
        if audioChatPlayer != nil{
            audioChatPlayer!.stop()
            audioChatPlayer = nil
            try? AVAudioSession.sharedInstance().setActive(false)
        }
    }
    
    static func stopDelayOrderAudio(){
        if audioDelayOrderPlayer != nil{
            audioDelayOrderPlayer!.stop()
            audioDelayOrderPlayer = nil
            try? AVAudioSession.sharedInstance().setActive(false)
        }
        
    }
    
    func audioPlayerDidFinishPlaying(_ player: AVAudioPlayer, successfully flag: Bool) {
        audioPlayer = nil
        try? AVAudioSession.sharedInstance().setActive(false)
    }
    
    func audioPlayerDecodeErrorDidOccur(_ player: AVAudioPlayer, error: Error?) {
        if error != nil{
            print(error!.localizedDescription)
        }
        audioPlayer = nil
        try? AVAudioSession.sharedInstance().setActive(false)
    }
}

class BadgeManager:NSObject{
    
    var isAPICalling = true
    private static var sharedInstance: BadgeManager?
    
    class var shared : BadgeManager? {
        if AppConstants.DataSyncMode != "Auto"{
            guard let sharedInstance = self.sharedInstance else {
                let sharedInstance = BadgeManager()
                self.sharedInstance = sharedInstance
                return sharedInstance
            }
            return sharedInstance
        }
        return nil
    }
    
    deinit {
        NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(CallGetCountAPI), object: nil)
    }
    
    func stopLastAPICall(){
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(CallGetCountAPI), object: nil)
            CallGetCountAPI()
        }
    }
    
    func userLogout(){
        NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(CallGetCountAPI), object: nil)
        CustomAudioPlayer.stopOrderAudio()
        CustomAudioPlayer.stopDelayOrderAudio()
    }
    
    @objc func CallGetCountAPI(){
        if AppConstants.userData == nil{
            self.userLogout()
            return
        }
        
        let dictParam = [String:Any]()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")/counts", method: "GET") { (message, response) in
            DispatchQueue.main.async {
                if let result = response as? NSDictionary{
                    self.checkAndPlayAudio(result: result)
                }
                self.perform(#selector(self.CallGetCountAPI), with: nil, afterDelay: 30)
            }
        }
    }
    
    func checkAndPlayAudio(result:NSDictionary){
        if AppConstants.userData == nil{
            self.userLogout()
            return
        }
        AppConstants.orderCount = result.getIntValue("pending_orders") ?? 0
        AppConstants.reservationCount = result.getIntValue("pending_bookings") ?? 0
        AppConstants.chatCount = result.getIntValue("unread_chat") ?? 0
        let delayOrder = result.getIntValue("delay_orders") ?? 0
        if AppConstants.orderCount == 0{
            CustomAudioPlayer.stopOrderAudio()
        }else{
            CustomAudioPlayer.prepareOrderPlayer()
        }
        if delayOrder == 0{
            CustomAudioPlayer.stopDelayOrderAudio()
        }else{
            CustomAudioPlayer.prepareDalyOrderPlayer()
        }
        NotificationCenter.default.post(name: AppConstants.notifications.kCountFetched, object: nil)
    }
}
